/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.queryserver.server;

import java.sql.SQLException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.calcite.avatica.Meta;
import org.apache.calcite.avatica.jdbc.JdbcMeta;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.phoenix.queryserver.server.PhoenixMetaFactory;

public class PhoenixMetaFactoryImpl
extends Configured
implements PhoenixMetaFactory {
    public static final String JDBC_PROTOCOL = "jdbc:phoenix";
    public static final char JDBC_PROTOCOL_SEPARATOR = ':';
    public static final char JDBC_PROTOCOL_TERMINATOR = ';';

    public PhoenixMetaFactoryImpl() {
        super(HBaseConfiguration.create());
    }

    public PhoenixMetaFactoryImpl(Configuration conf) {
        super(conf);
    }

    @Override
    public Meta create(List<String> args) {
        Configuration conf = this.getConf();
        if (conf == null) {
            throw new NullPointerException(String.valueOf("Configuration must not be null."));
        }
        Properties info = new Properties();
        info.putAll((Map<?, ?>)conf.getValByRegex("avatica.*"));
        try {
            String url;
            if (args.size() == 0) {
                url = this.getConnectionUrl(info, conf);
            } else if (args.size() == 1) {
                url = args.get(0);
            } else {
                throw new RuntimeException("0 or 1 argument expected. Received " + Arrays.toString(args.toArray()));
            }
            return new JdbcMeta(url, info);
        }
        catch (ClassNotFoundException | SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public String getConnectionUrl(Properties props, Configuration conf) throws ClassNotFoundException, SQLException {
        int port = this.getInt("hbase.zookeeper.property.clientPort", 2181, props, conf);
        String server = this.getString("hbase.zookeeper.quorum", "localhost", props, conf);
        String znodeParent = this.getString("zookeeper.znode.parent", "/hbase", props, conf);
        String url = PhoenixMetaFactoryImpl.getUrl(server, port, znodeParent);
        if (url.endsWith(";")) {
            url = url.substring(0, url.length() - 1);
        }
        String defaultExtraArgs = conf != null ? conf.get("phoenix.jdbc.extra.arguments", "") : "";
        String extraArgs = props.getProperty("phoenix.jdbc.extra.arguments", defaultExtraArgs);
        url = extraArgs.length() > 0 ? url + ';' + extraArgs + ';' : url + ';';
        return url;
    }

    private int getInt(String key, int defaultValue, Properties props, Configuration conf) {
        if (conf == null) {
            if (props == null) {
                throw new NullPointerException();
            }
            return Integer.parseInt(props.getProperty(key, String.valueOf(defaultValue)));
        }
        return conf.getInt(key, defaultValue);
    }

    private String getString(String key, String defaultValue, Properties props, Configuration conf) {
        if (conf == null) {
            if (props == null) {
                throw new NullPointerException();
            }
            return props.getProperty(key, defaultValue);
        }
        return conf.get(key, defaultValue);
    }

    private static String getUrl(String zookeeperQuorum, Integer port, String rootNode) {
        return "jdbc:phoenix:" + zookeeperQuorum + (port == null ? "" : ":" + port) + (rootNode == null ? "" : ":" + rootNode) + ';';
    }
}

