/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.event;

import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.context.ContextNotActiveException;
import javax.enterprise.context.Dependent;
import javax.enterprise.context.spi.Context;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.event.Event;
import javax.enterprise.event.Observes;
import javax.enterprise.event.Reception;
import javax.enterprise.event.TransactionPhase;
import javax.enterprise.inject.spi.AnnotatedMethod;
import javax.enterprise.inject.spi.AnnotatedParameter;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.InjectionPoint;
import org.apache.webbeans.annotation.AnnotationManager;
import org.apache.webbeans.component.AbstractOwbBean;
import org.apache.webbeans.component.WebBeansType;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.container.BeanManagerImpl;
import org.apache.webbeans.event.EventMetadata;
import org.apache.webbeans.event.EventUtil;
import org.apache.webbeans.event.OwbObserverMethod;
import org.apache.webbeans.exception.WebBeansException;
import org.apache.webbeans.inject.impl.InjectionPointFactory;
import org.apache.webbeans.logger.WebBeansLoggerFacade;
import org.apache.webbeans.proxy.InterceptorDecoratorProxyFactory;
import org.apache.webbeans.proxy.OwbNormalScopeProxy;
import org.apache.webbeans.spi.plugins.OpenWebBeansEjbPlugin;
import org.apache.webbeans.util.AnnotationUtil;

public class ObserverMethodImpl<T>
implements OwbObserverMethod<T> {
    private static final Logger logger = WebBeansLoggerFacade.getLogger(ObserverMethodImpl.class);
    private final AbstractOwbBean<?> bean;
    private final boolean ifExist;
    private final Set<Annotation> observedQualifiers;
    private final Type observedEventType;
    private final TransactionPhase phase;
    private final Method view;
    private AnnotatedMethod<T> annotatedObserverMethod;

    public ObserverMethodImpl(AbstractOwbBean<?> bean, AnnotatedMethod<T> annotatedObserverMethod, boolean ifExist, Annotation[] qualifiers, Type observedEventType) {
        this.bean = bean;
        this.annotatedObserverMethod = annotatedObserverMethod;
        this.ifExist = ifExist;
        this.observedQualifiers = new HashSet<Annotation>(qualifiers.length);
        Collections.addAll(this.observedQualifiers, qualifiers);
        this.observedEventType = observedEventType;
        this.phase = EventUtil.getObserverMethodTransactionType(annotatedObserverMethod);
        OpenWebBeansEjbPlugin ejbPlugin = this.getWebBeansContext().getPluginLoader().getEjbPlugin();
        this.view = ejbPlugin != null && ejbPlugin.isNewSessionBean(bean.getBeanClass()) ? ejbPlugin.resolveViewMethod(bean, annotatedObserverMethod.getJavaMember()) : annotatedObserverMethod.getJavaMember();
    }

    public void notify(T event) {
        this.notify(event, null);
    }

    @Override
    public void notify(T event, EventMetadata metadata) {
        block27: {
            AbstractOwbBean<?> component = this.bean;
            if (!this.bean.isEnabled()) {
                return;
            }
            Object object = null;
            List<ObserverParams> methodArgsMap = this.getMethodArguments(event, metadata);
            BeanManagerImpl manager = this.bean.getWebBeansContext().getBeanManagerImpl();
            CreationalContext creationalContext = manager.createCreationalContext((Contextual)component);
            if (metadata != null) {
                creationalContext.putInjectionPoint(metadata.getInjectionPoint());
            }
            ObserverParams[] obargs = null;
            try {
                Context context;
                obargs = new ObserverParams[methodArgsMap.size()];
                obargs = methodArgsMap.toArray(obargs);
                Object[] args = new Object[obargs.length];
                int i = 0;
                for (ObserverParams param : obargs) {
                    args[i++] = param.instance;
                }
                if (Modifier.isStatic(this.view.getModifiers())) {
                    if (!this.view.isAccessible()) {
                        this.view.setAccessible(true);
                    }
                    this.view.invoke(null, args);
                    break block27;
                }
                try {
                    context = manager.getContext(component.getScope());
                }
                catch (ContextNotActiveException cnae) {
                    logger.log(Level.INFO, "INFO_0010", this.bean);
                    creationalContext.removeInjectionPoint();
                    if (component.getScope().equals(Dependent.class) && object != null) {
                        component.destroy(object, creationalContext);
                    }
                    if (methodArgsMap != null) {
                        for (ObserverParams param : obargs) {
                            if (!param.isBean || !param.bean.getScope().equals(Dependent.class)) continue;
                            param.bean.destroy(param.instance, param.creational);
                        }
                    }
                    return;
                }
                object = context.get(component);
                if (this.ifExist && object == null) {
                    return;
                }
                if (object == null) {
                    object = context.get(component, creationalContext);
                }
                if (object == null) {
                    Type t = component.getBeanClass();
                    if (component.getWebBeansType() == WebBeansType.ENTERPRISE) {
                        t = (Type)component.getTypes().toArray()[0];
                    }
                    object = manager.getReference(component, t, creationalContext);
                }
                if (object != null) {
                    if (!this.view.isAccessible()) {
                        this.bean.getWebBeansContext().getSecurityService().doPrivilegedSetAccessible((AccessibleObject)this.view, true);
                    }
                    if (Modifier.isPrivate(this.view.getModifiers()) && object instanceof OwbNormalScopeProxy) {
                        this.getWebBeansContext().getInterceptorDecoratorProxyFactory();
                        object = InterceptorDecoratorProxyFactory.unwrapInstance(object);
                    }
                    this.view.invoke(object, args);
                }
            }
            catch (Exception e) {
                throw new WebBeansException(e);
            }
            finally {
                creationalContext.removeInjectionPoint();
                if (component.getScope().equals(Dependent.class) && object != null) {
                    component.destroy(object, creationalContext);
                }
                if (methodArgsMap != null) {
                    for (ObserverParams param : obargs) {
                        if (!param.isBean || !param.bean.getScope().equals(Dependent.class)) continue;
                        param.bean.destroy(param.instance, param.creational);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<ObserverParams> getMethodArguments(Object event, EventMetadata metadata) {
        WebBeansContext webBeansContext = this.bean.getWebBeansContext();
        AnnotationManager annotationManager = webBeansContext.getAnnotationManager();
        BeanManagerImpl manager = webBeansContext.getBeanManagerImpl();
        ArrayList<ObserverParams> list = new ArrayList<ObserverParams>();
        List parameters = this.annotatedObserverMethod.getParameters();
        ObserverParams param = null;
        for (AnnotatedParameter parameter : parameters) {
            Object instance;
            if (parameter.isAnnotationPresent(Observes.class)) {
                param = new ObserverParams();
                param.instance = event;
                list.add(param);
                continue;
            }
            Annotation[] bindingTypes = annotationManager.getQualifierAnnotations(AnnotationUtil.asArray(parameter.getAnnotations()));
            InjectionPoint point = InjectionPointFactory.getPartialInjectionPoint(this.bean, parameter, bindingTypes);
            Bean<?> injectedBean = this.getWebBeansContext().getBeanManagerImpl().getInjectionResolver().getInjectionPointBean(point);
            CreationalContext creational = manager.createCreationalContext((Contextual)injectedBean);
            creational.putInjectionPoint(metadata.getInjectionPoint());
            creational.putInjectionPoint(point);
            try {
                instance = manager.getReference(injectedBean, null, creational);
            }
            finally {
                creational.removeInjectionPoint();
                creational.removeInjectionPoint();
            }
            param = new ObserverParams();
            param.isBean = true;
            param.creational = creational;
            param.instance = instance;
            param.bean = injectedBean;
            list.add(param);
        }
        return list;
    }

    private boolean isEventProviderInjection(InjectionPoint injectionPoint) {
        ParameterizedType pt;
        Class clazz;
        Type type = injectionPoint.getType();
        return type instanceof ParameterizedType && (clazz = (Class)(pt = (ParameterizedType)type).getRawType()).isAssignableFrom(Event.class);
    }

    public Class<?> getBeanClass() {
        return this.bean.getBeanClass();
    }

    public Set<Annotation> getObservedQualifiers() {
        return this.observedQualifiers;
    }

    public Type getObservedType() {
        return this.observedEventType;
    }

    public Reception getReception() {
        return this.ifExist ? Reception.IF_EXISTS : Reception.ALWAYS;
    }

    public TransactionPhase getTransactionPhase() {
        return this.phase;
    }

    public AnnotatedMethod<T> getObserverMethod() {
        return this.annotatedObserverMethod;
    }

    protected WebBeansContext getWebBeansContext() {
        return this.bean.getWebBeansContext();
    }

    public void setObserverMethod(AnnotatedMethod<T> m) {
        this.annotatedObserverMethod = m;
    }

    private static class ObserverParams {
        private Bean<Object> bean;
        private Object instance;
        private CreationalContext<Object> creational;
        private boolean isBean = false;

        private ObserverParams() {
        }
    }
}

