"use strict";
/*! Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to you under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.HiddenInputBuilder = void 0;
const mona_dish_1 = require("mona-dish");
const Const_1 = require("../core/Const");
/**
 * Builder for hidden inputs.
 * ATM only ViewState and Client window
 * are supported (per spec)
 *
 * Improves readability in the response processor!
 */
class HiddenInputBuilder {
    constructor(selector) {
        this.selector = selector;
        this.namedViewRoot = false;
        const isViewState = selector.indexOf((0, Const_1.$nsp)(Const_1.P_VIEWSTATE)) != -1;
        this.name = isViewState ? Const_1.P_VIEWSTATE : Const_1.P_CLIENT_WINDOW;
        this.template = isViewState ? Const_1.HTML_VIEWSTATE : Const_1.HTML_CLIENT_WINDOW;
    }
    withNamingContainerId(namingContainer) {
        this.namingContainerId = namingContainer;
        return this;
    }
    withParent(parent) {
        this.parent = parent;
        return this;
    }
    withNamedViewRoot(namedViewRoot) {
        this.namedViewRoot = namedViewRoot;
        return this;
    }
    build() {
        var _a, _b, _c;
        const SEP = (0, Const_1.$faces)().separatorchar;
        let existingStates = (0, mona_dish_1.DQ$)(`[name*='${(0, Const_1.$nsp)(this.name)}']`);
        let cnt = existingStates.stream.map(state => {
            let ident = state.id.orElse("-1").value;
            ident = ident.substring(ident.lastIndexOf(SEP) + 1);
            return parseInt(ident);
        })
            .filter(item => !isNaN(item))
            .reduce((item1, item2) => Math.max(item1, item2), -1).value;
        //the maximum  new ident is the current max + 1
        cnt++;
        const newElement = mona_dish_1.DQ.fromMarkup((0, Const_1.$nsp)(this.template));
        newElement.id.value = (((_a = this.namingContainerId) === null || _a === void 0 ? void 0 : _a.length) ?
            [this.namingContainerId, (0, Const_1.$nsp)(this.name), cnt] :
            [(0, Const_1.$nsp)(this.name), cnt]).join(SEP);
        //name must be prefixed with the naming container id as well according to the jsdocs
        if (this.namedViewRoot) {
            newElement.name.value = ((_b = this.namingContainerId) === null || _b === void 0 ? void 0 : _b.length) ?
                [this.namingContainerId, (0, Const_1.$nsp)(this.name)].join(SEP) : (0, Const_1.$nsp)(this.name);
        }
        else {
            newElement.name.value = (0, Const_1.$nsp)(this.name);
        }
        (_c = this === null || this === void 0 ? void 0 : this.parent) === null || _c === void 0 ? void 0 : _c.append(newElement);
        return newElement;
    }
}
exports.HiddenInputBuilder = HiddenInputBuilder;
//# sourceMappingURL=HiddenInputBuilder.js.map