/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.client.bindings.impl;

import java.io.Serializable;
import java.math.BigInteger;
import java.util.Collection;
import java.util.List;
import org.apache.chemistry.opencmis.client.bindings.cache.TypeDefinitionCache;
import org.apache.chemistry.opencmis.client.bindings.impl.CmisBindingsHelper;
import org.apache.chemistry.opencmis.client.bindings.impl.RepositoryInfoCache;
import org.apache.chemistry.opencmis.client.bindings.spi.BindingSession;
import org.apache.chemistry.opencmis.client.bindings.spi.CmisSpi;
import org.apache.chemistry.opencmis.commons.data.ExtensionsData;
import org.apache.chemistry.opencmis.commons.data.RepositoryInfo;
import org.apache.chemistry.opencmis.commons.definitions.TypeDefinition;
import org.apache.chemistry.opencmis.commons.definitions.TypeDefinitionContainer;
import org.apache.chemistry.opencmis.commons.definitions.TypeDefinitionList;
import org.apache.chemistry.opencmis.commons.impl.CollectionsHelper;
import org.apache.chemistry.opencmis.commons.spi.ExtendedRepositoryService;
import org.apache.chemistry.opencmis.commons.spi.RepositoryService;

public class RepositoryServiceImpl
implements RepositoryService,
ExtendedRepositoryService,
Serializable {
    private static final long serialVersionUID = 1L;
    private final BindingSession session;

    public RepositoryServiceImpl(BindingSession session) {
        assert (session != null);
        this.session = session;
    }

    public RepositoryInfo getRepositoryInfo(String repositoryId, ExtensionsData extension) {
        RepositoryInfo result = null;
        boolean hasExtension = extension != null && CollectionsHelper.isNotEmpty((Collection)extension.getExtensions());
        RepositoryInfoCache cache = CmisBindingsHelper.getRepositoryInfoCache(this.session);
        if (!hasExtension && (result = cache.get(repositoryId)) != null) {
            return result;
        }
        CmisSpi spi = CmisBindingsHelper.getSPI(this.session);
        result = spi.getRepositoryService().getRepositoryInfo(repositoryId, extension);
        if (!hasExtension) {
            cache.put(result);
        }
        return result;
    }

    public List<RepositoryInfo> getRepositoryInfos(ExtensionsData extension) {
        List result = null;
        boolean hasExtension = extension != null && CollectionsHelper.isNotEmpty((Collection)extension.getExtensions());
        CmisSpi spi = CmisBindingsHelper.getSPI(this.session);
        result = spi.getRepositoryService().getRepositoryInfos(extension);
        if (!hasExtension && result != null) {
            RepositoryInfoCache cache = CmisBindingsHelper.getRepositoryInfoCache(this.session);
            for (RepositoryInfo rid : result) {
                cache.put(rid);
            }
        }
        return result;
    }

    public TypeDefinitionList getTypeChildren(String repositoryId, String typeId, Boolean includePropertyDefinitions, BigInteger maxItems, BigInteger skipCount, ExtensionsData extension) {
        TypeDefinitionList result = null;
        boolean hasExtension = extension != null && CollectionsHelper.isNotEmpty((Collection)extension.getExtensions());
        boolean propDefs = includePropertyDefinitions == null ? false : includePropertyDefinitions;
        CmisSpi spi = CmisBindingsHelper.getSPI(this.session);
        result = spi.getRepositoryService().getTypeChildren(repositoryId, typeId, includePropertyDefinitions, maxItems, skipCount, extension);
        if (!hasExtension && propDefs && result != null) {
            TypeDefinitionCache cache = CmisBindingsHelper.getTypeDefinitionCache(this.session);
            for (TypeDefinition tdd : result.getList()) {
                cache.put(repositoryId, tdd);
            }
        }
        return result;
    }

    public TypeDefinition getTypeDefinition(String repositoryId, String typeId, ExtensionsData extension) {
        return this.getTypeDefinition(repositoryId, typeId, extension, true);
    }

    public TypeDefinition getTypeDefinition(String repositoryId, String typeId, ExtensionsData extension, boolean useCache) {
        TypeDefinition result = null;
        boolean hasExtension = extension != null && CollectionsHelper.isNotEmpty((Collection)extension.getExtensions());
        TypeDefinitionCache cache = CmisBindingsHelper.getTypeDefinitionCache(this.session);
        if (useCache && !hasExtension && (result = cache.get(repositoryId, typeId)) != null) {
            return result;
        }
        CmisSpi spi = CmisBindingsHelper.getSPI(this.session);
        result = spi.getRepositoryService().getTypeDefinition(repositoryId, typeId, extension);
        if (!hasExtension && result != null) {
            cache.put(repositoryId, result);
        }
        return result;
    }

    public List<TypeDefinitionContainer> getTypeDescendants(String repositoryId, String typeId, BigInteger depth, Boolean includePropertyDefinitions, ExtensionsData extension) {
        List result = null;
        boolean hasExtension = extension != null && CollectionsHelper.isNotEmpty((Collection)extension.getExtensions());
        boolean propDefs = includePropertyDefinitions == null ? false : includePropertyDefinitions;
        CmisSpi spi = CmisBindingsHelper.getSPI(this.session);
        result = spi.getRepositoryService().getTypeDescendants(repositoryId, typeId, depth, includePropertyDefinitions, extension);
        if (!hasExtension && propDefs && result != null) {
            TypeDefinitionCache cache = CmisBindingsHelper.getTypeDefinitionCache(this.session);
            this.addToTypeCache(cache, repositoryId, result);
        }
        return result;
    }

    private void addToTypeCache(TypeDefinitionCache cache, String repositoryId, List<TypeDefinitionContainer> containers) {
        if (containers == null) {
            return;
        }
        for (TypeDefinitionContainer container : containers) {
            cache.put(repositoryId, container.getTypeDefinition());
            this.addToTypeCache(cache, repositoryId, container.getChildren());
        }
    }

    public TypeDefinition createType(String repositoryId, TypeDefinition type, ExtensionsData extension) {
        CmisSpi spi = CmisBindingsHelper.getSPI(this.session);
        TypeDefinition result = spi.getRepositoryService().createType(repositoryId, type, extension);
        TypeDefinitionCache cache = CmisBindingsHelper.getTypeDefinitionCache(this.session);
        cache.put(repositoryId, result);
        return result;
    }

    public TypeDefinition updateType(String repositoryId, TypeDefinition type, ExtensionsData extension) {
        CmisSpi spi = CmisBindingsHelper.getSPI(this.session);
        TypeDefinition result = spi.getRepositoryService().updateType(repositoryId, type, extension);
        TypeDefinitionCache cache = CmisBindingsHelper.getTypeDefinitionCache(this.session);
        cache.put(repositoryId, result);
        return result;
    }

    public void deleteType(String repositoryId, String typeId, ExtensionsData extension) {
        CmisSpi spi = CmisBindingsHelper.getSPI(this.session);
        spi.getRepositoryService().deleteType(repositoryId, typeId, extension);
        TypeDefinitionCache cache = CmisBindingsHelper.getTypeDefinitionCache(this.session);
        cache.remove(repositoryId, typeId);
    }
}

