/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;

class MarkableFileInputStream
extends InputStream {
    private FileInputStream in;
    private long markedPosition = -1L;
    private IOException markException;

    MarkableFileInputStream(File file) throws FileNotFoundException {
        this.in = new FileInputStream(file);
    }

    @Override
    public synchronized void mark(int readlimit) {
        try {
            this.markedPosition = this.in.getChannel().position();
        }
        catch (IOException e) {
            this.markedPosition = -1L;
        }
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    private void throwMarkExceptionIfOccured() throws IOException {
        if (this.markException != null) {
            throw this.markException;
        }
    }

    @Override
    public synchronized void reset() throws IOException {
        this.throwMarkExceptionIfOccured();
        if (this.markedPosition < 0L) {
            throw new IOException("Stream has to be marked before it can be reset!");
        }
        this.in.getChannel().position(this.markedPosition);
    }

    @Override
    public int read() throws IOException {
        return this.in.read();
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.in.read(b);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        return this.in.read(b, off, len);
    }
}

