/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.feature;

import java.util.AbstractList;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.sis.feature.Field;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.resources.Errors;

final class PropertySingleton<V>
extends AbstractList<V> {
    private final Field<V> property;

    PropertySingleton(Field<V> field) {
        this.property = field;
    }

    @Override
    public int size() {
        return this.property.getValue() == null ? 0 : 1;
    }

    @Override
    public int indexOf(Object object) {
        return object != null && object.equals(this.property.getValue()) ? 0 : -1;
    }

    @Override
    public int lastIndexOf(Object object) {
        return this.indexOf(object);
    }

    @Override
    public V get(int n) {
        V v;
        if (n == 0 && (v = this.property.getValue()) != null) {
            return v;
        }
        throw new IndexOutOfBoundsException(Errors.format((short)71, n));
    }

    @Override
    public V set(int n, V v) {
        V v2;
        ArgumentChecks.ensureNonNull("element", v);
        if (n == 0 && (v2 = this.property.getValue()) != null) {
            this.property.setValue(v);
            ++this.modCount;
            return v2;
        }
        throw new IndexOutOfBoundsException(Errors.format((short)71, n));
    }

    @Override
    public void add(int n, V v) {
        if (n != 0) {
            throw new IndexOutOfBoundsException(Errors.format((short)71, n));
        }
        this.add(v);
    }

    @Override
    public boolean add(V v) {
        ArgumentChecks.ensureNonNull("element", v);
        if (this.property.getValue() == null) {
            this.property.setValue(v);
            ++this.modCount;
            return true;
        }
        throw new IllegalStateException(Errors.format((short)27, this.property.getName()));
    }

    @Override
    public V remove(int n) {
        V v;
        if (n == 0 && (v = this.property.getValue()) != null) {
            this.clear();
            return v;
        }
        throw new IndexOutOfBoundsException(Errors.format((short)71, n));
    }

    final void clear(int n) {
        if (n != this.modCount) {
            throw new ConcurrentModificationException(String.valueOf(this.property.getName()));
        }
        this.property.setValue(null);
    }

    @Override
    public void clear() {
        this.property.setValue(null);
        ++this.modCount;
    }

    @Override
    public Object[] toArray() {
        Object[] objectArray;
        V v = this.property.getValue();
        if (v == null) {
            objectArray = new Object[]{};
        } else {
            Object[] objectArray2 = new Object[1];
            objectArray = objectArray2;
            objectArray2[0] = v;
        }
        return objectArray;
    }

    @Override
    public int hashCode() {
        int n;
        V v = this.property.getValue();
        int n2 = n = v != null ? 31 + v.hashCode() : 1;
        assert (n == super.hashCode()) : n;
        return n;
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof List) {
            V v = this.property.getValue();
            if (v == null) {
                return ((List)object).isEmpty();
            }
            Iterator iterator = ((List)object).iterator();
            return iterator.hasNext() && v.equals(iterator.next()) && !iterator.hasNext();
        }
        return false;
    }

    @Override
    public Iterator<V> iterator() {
        return new Iter(this.property.getValue(), this.modCount);
    }

    private final class Iter
    implements Iterator<V> {
        private V element;
        private final int c;

        Iter(V v, int n) {
            this.element = v;
            this.c = n;
        }

        @Override
        public boolean hasNext() {
            return this.element != null;
        }

        @Override
        public V next() {
            Object v = this.element;
            if (v == null) {
                throw new NoSuchElementException();
            }
            this.element = null;
            return v;
        }

        @Override
        public void remove() {
            if (this.element != null) {
                throw new IllegalStateException();
            }
            PropertySingleton.this.clear(this.c);
        }
    }
}

