/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.pdf;

import java.awt.geom.Point2D;
import org.apache.fop.pdf.PDFAction;
import org.apache.fop.pdf.PDFObject;

public class PDFGoTo
extends PDFAction {
    private String pageReference;
    private String destination = null;
    private float xPosition = 0.0f;
    private float yPosition = 0.0f;

    public PDFGoTo(String pageReference) {
        this.pageReference = pageReference;
    }

    public PDFGoTo(String pageReference, Point2D position) {
        this.pageReference = pageReference;
        this.setPosition(position);
    }

    public void setPageReference(String pageReference) {
        this.pageReference = pageReference;
    }

    public void setPosition(Point2D position) {
        this.xPosition = (float)position.getX();
        this.yPosition = (float)position.getY();
    }

    public void setXPosition(float xPosition) {
        this.xPosition = xPosition;
    }

    public void setYPosition(float yPosition) {
        this.yPosition = yPosition;
    }

    public void setDestination(String dest) {
        this.destination = dest;
    }

    public String getAction() {
        return this.referencePDF();
    }

    public String toPDFString() {
        String dest = this.destination == null ? "/D [" + this.pageReference + " /XYZ " + this.xPosition + " " + this.yPosition + " null]\n" : "/D [" + this.pageReference + " " + this.destination + "]\n";
        return this.getObjectID() + "<< /Type /Action\n/S /GoTo\n" + dest + ">>\nendobj\n";
    }

    protected boolean contentEquals(PDFObject obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof PDFGoTo)) {
            return false;
        }
        PDFGoTo gt = (PDFGoTo)obj;
        if (gt.pageReference == null ? this.pageReference != null : !gt.pageReference.equals(this.pageReference)) {
            return false;
        }
        return !(this.destination == null ? gt.destination != null || gt.xPosition != this.xPosition || gt.yPosition != this.yPosition : !this.destination.equals(gt.destination));
    }
}

