/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.operation.transform;

import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.Arrays;
import org.apache.sis.referencing.operation.matrix.Matrix3;
import org.apache.sis.referencing.operation.transform.CoordinateSystemTransform;
import org.apache.sis.referencing.operation.transform.IterationStrategy;
import org.apache.sis.referencing.operation.transform.SphericalToCartesian;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.Matrix;

final class CartesianToSpherical
extends CoordinateSystemTransform
implements Serializable {
    private static final long serialVersionUID = 7174557821232512348L;
    static final CartesianToSpherical INSTANCE = new CartesianToSpherical();

    private Object readResolve() throws ObjectStreamException {
        return INSTANCE;
    }

    private CartesianToSpherical() {
        super("Cartesian to spherical", null, 3);
        this.context.denormalizeGeographicOutputs(0.0);
    }

    @Override
    public MathTransform inverse() {
        return SphericalToCartesian.INSTANCE;
    }

    @Override
    public Matrix transform(double[] dArray, int n, double[] dArray2, int n2, boolean bl) {
        double d = dArray[n];
        double d2 = dArray[n + 1];
        double d3 = dArray[n + 2];
        double d4 = d * d + d2 * d2;
        double d5 = d3 * d3 + d4;
        double d6 = Math.sqrt(d5);
        if (dArray2 != null) {
            dArray2[n2] = Math.atan2(d2, d);
            dArray2[n2 + 1] = d6 == 0.0 ? d3 : Math.asin(d3 / d6);
            dArray2[n2 + 2] = d6;
        }
        if (!bl) {
            return null;
        }
        double d7 = d5 * Math.sqrt(d5 - d3 * d3);
        return new Matrix3(-d2 / d4, d / d4, 0.0, -d * d3 / d7, -d2 * d3 / d7, d4 / d7, d / d6, d2 / d6, d3 / d6);
    }

    @Override
    public void transform(double[] dArray, int n, double[] dArray2, int n2, int n3) {
        int n4 = 0;
        int n5 = 0;
        if (dArray == dArray2) {
            switch (IterationStrategy.suggest(n, 3, n2, 3, n3)) {
                case ASCENDING: {
                    break;
                }
                case DESCENDING: {
                    n += 3 * (n3 - 1);
                    n2 += 3 * (n3 - 1);
                    n4 = -6;
                    n5 = -6;
                    break;
                }
                default: {
                    dArray = Arrays.copyOfRange(dArray, n, n + n3 * 3);
                    n = 0;
                }
            }
        }
        while (--n3 >= 0) {
            double d = dArray[n++];
            double d2 = dArray[n++];
            double d3 = dArray[n++];
            double d4 = Math.sqrt(d * d + d2 * d2 + d3 * d3);
            dArray2[n2++] = Math.atan2(d2, d);
            dArray2[n2++] = d4 == 0.0 ? d3 : Math.asin(d3 / d4);
            dArray2[n2++] = d4;
            n += n4;
            n2 += n5;
        }
    }
}

