/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.common.util;

import java.lang.reflect.Constructor;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.HashMap;
import java.util.Map;
import org.apache.cxf.common.classloader.ClassLoaderUtils;
import org.apache.cxf.common.util.ASMHelper;
import org.apache.cxf.common.util.OpcodesProxy;
import org.apache.cxf.common.util.ReflectionInvokationHandler;
import org.apache.cxf.common.util.ReflectionUtil;
import org.apache.cxf.common.util.StringUtils;
import org.objectweb.asm.ClassWriter;

public class ASMHelperImpl
implements ASMHelper {
    protected static final Map<Class<?>, String> PRIMITIVE_MAP = new HashMap();
    protected static final Map<Class<?>, String> NONPRIMITIVE_MAP = new HashMap();
    protected static final Map<Class<?>, Integer> PRIMITIVE_ZERO_MAP = new HashMap();
    protected boolean badASM;
    private Class<?> cwClass;

    private void tryClass(String s) {
        if (this.cwClass == null) {
            try {
                Class<?> c2 = ClassLoaderUtils.loadClass(s, ASMHelperImpl.class);
                Class<?> cls = ClassLoaderUtils.loadClass(c2.getPackage().getName() + ".MethodVisitor", c2);
                cls.getMethod("visitFrame", Integer.TYPE, Integer.TYPE, Object[].class, Integer.TYPE, Object[].class);
                this.cwClass = c2;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private Class<?> getASMClassWriterClass() {
        return ClassWriter.class;
    }

    @Override
    public synchronized Class<?> getASMClass() throws ClassNotFoundException {
        if (this.cwClass == null) {
            this.tryClass("org.objectweb.asm.ClassWriter");
            this.tryClass("org.apache.xbean.asm9.ClassWriter");
            this.tryClass("org.apache.xbean.asm8.ClassWriter");
            this.tryClass("org.apache.xbean.asm7.ClassWriter");
            this.tryClass("org.apache.xbean.asm5.ClassWriter");
            this.tryClass("org.apache.xbean.asm6.ClassWriter");
            this.tryClass("org.apache.xbean.asm4.ClassWriter");
            this.tryClass("org.apache.xbean.asm.ClassWriter");
            this.tryClass("org.springframework.asm.ClassWriter");
            if (this.cwClass == null) {
                this.cwClass = this.getASMClassWriterClass();
            }
        }
        return this.cwClass;
    }

    @Override
    public OpcodesProxy getOpCodes() {
        OpcodesProxy ops = new OpcodesProxy(this);
        PRIMITIVE_ZERO_MAP.put(Byte.TYPE, ops.ICONST_0);
        PRIMITIVE_ZERO_MAP.put(Boolean.TYPE, ops.ICONST_0);
        PRIMITIVE_ZERO_MAP.put(Long.TYPE, ops.LCONST_0);
        PRIMITIVE_ZERO_MAP.put(Integer.TYPE, ops.ICONST_0);
        PRIMITIVE_ZERO_MAP.put(Short.TYPE, ops.ICONST_0);
        PRIMITIVE_ZERO_MAP.put(Character.TYPE, ops.ICONST_0);
        PRIMITIVE_ZERO_MAP.put(Float.TYPE, ops.FCONST_0);
        PRIMITIVE_ZERO_MAP.put(Double.TYPE, ops.DCONST_0);
        return ops;
    }

    public void setBadASM(boolean b) {
        this.badASM = b;
    }

    @Override
    public String getMethodSignature(Method m) {
        StringBuilder buf = new StringBuilder("(");
        for (Class<?> cl : m.getParameterTypes()) {
            buf.append(this.getClassCode(cl));
        }
        buf.append(')');
        buf.append(this.getClassCode(m.getReturnType()));
        return buf.toString();
    }

    @Override
    public String getNonPrimitive(Class<?> tp) {
        return NONPRIMITIVE_MAP.get(tp);
    }

    @Override
    public String getPrimitive(Class<?> tp) {
        return PRIMITIVE_MAP.get(tp);
    }

    @Override
    public String getClassCode(Class<?> cl) {
        if (cl == Void.TYPE) {
            return "V";
        }
        if (cl.isPrimitive()) {
            return PRIMITIVE_MAP.get(cl);
        }
        if (cl.isArray()) {
            return "[" + this.getClassCode(cl.getComponentType());
        }
        return "L" + StringUtils.periodToSlashes(cl.getName()) + ";";
    }

    @Override
    public String getClassCode(Type type) {
        if (type instanceof Class) {
            return this.getClassCode((Class)type);
        }
        if (type instanceof GenericArrayType) {
            GenericArrayType at = (GenericArrayType)type;
            return "[" + this.getClassCode(at.getGenericComponentType());
        }
        if (type instanceof TypeVariable) {
            TypeVariable tv = (TypeVariable)type;
            Type[] bounds = tv.getBounds();
            if (bounds != null && bounds.length == 1) {
                return this.getClassCode(bounds[0]);
            }
            throw new IllegalArgumentException("Unable to determine type for: " + tv);
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)type;
            StringBuilder a = new StringBuilder(this.getClassCode(pt.getRawType()));
            if (!pt.getRawType().equals(Enum.class)) {
                a.setLength(a.length() - 1);
                a.append('<');
                for (Type t : pt.getActualTypeArguments()) {
                    a.append(this.getClassCode(t));
                }
                a.append(">;");
            }
            return a.toString();
        }
        if (type instanceof WildcardType) {
            Type[] upBounds;
            WildcardType wt = (WildcardType)type;
            StringBuilder a = new StringBuilder();
            Type[] lowBounds = wt.getLowerBounds();
            for (Type t : upBounds = wt.getUpperBounds()) {
                a.append('+');
                a.append(this.getClassCode(t));
            }
            for (Type t : lowBounds) {
                a.append('-');
                a.append(this.getClassCode(t));
            }
            return a.toString();
        }
        return null;
    }

    @Override
    public ASMHelper.ClassWriter createClassWriter() {
        Object newCw = null;
        if (!this.badASM) {
            if (this.cwClass == null) {
                try {
                    this.cwClass = this.getASMClass();
                }
                catch (Throwable error) {
                    this.badASM = true;
                    throw new RuntimeException("No ASM ClassWriterFound", error);
                }
            }
            try {
                Constructor<?> cons = this.cwClass.getConstructor(Integer.TYPE);
                int i = this.cwClass.getField("COMPUTE_MAXS").getInt(null);
                newCw = cons.newInstance(i |= this.cwClass.getField("COMPUTE_FRAMES").getInt(null));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (newCw != null) {
            return ReflectionInvokationHandler.createProxyWrapper(newCw, ASMHelper.ClassWriter.class);
        }
        return null;
    }

    @Override
    public ASMHelper.ASMType getType(final String type) {
        try {
            final Class<?> cls = ClassLoaderUtils.loadClass(this.cwClass.getPackage().getName() + ".Type", this.cwClass);
            final Method m = cls.getMethod("getType", String.class);
            final Method m2 = cls.getMethod("getOpcode", Integer.TYPE);
            ASMHelper.ASMType t = new ASMHelper.ASMType(){
                Object tp;
                {
                    this.tp = ReflectionUtil.setAccessible(m).invoke(null, type);
                }

                public Object getValue() {
                    return this.tp;
                }

                public Class<?> realType() {
                    return cls;
                }

                @Override
                public int getOpcode(int ireturn) {
                    try {
                        return (Integer)ReflectionUtil.setAccessible(m2).invoke(this.tp, ireturn);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            };
            return t;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public ASMHelper.Label createLabel() {
        try {
            final Class<?> cls = ClassLoaderUtils.loadClass(this.cwClass.getPackage().getName() + ".Label", this.cwClass);
            ASMHelper.Label l = new ASMHelper.Label(){
                Object l;
                {
                    this.l = cls.newInstance();
                }

                public Object getValue() {
                    return this.l;
                }

                public Class<?> realType() {
                    return cls;
                }
            };
            return l;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    static {
        PRIMITIVE_MAP.put(Byte.TYPE, "B");
        PRIMITIVE_MAP.put(Boolean.TYPE, "Z");
        PRIMITIVE_MAP.put(Long.TYPE, "J");
        PRIMITIVE_MAP.put(Integer.TYPE, "I");
        PRIMITIVE_MAP.put(Short.TYPE, "S");
        PRIMITIVE_MAP.put(Character.TYPE, "C");
        PRIMITIVE_MAP.put(Float.TYPE, "F");
        PRIMITIVE_MAP.put(Double.TYPE, "D");
        NONPRIMITIVE_MAP.put(Byte.TYPE, Byte.class.getName().replaceAll("\\.", "/"));
        NONPRIMITIVE_MAP.put(Boolean.TYPE, Boolean.class.getName().replaceAll("\\.", "/"));
        NONPRIMITIVE_MAP.put(Long.TYPE, Long.class.getName().replaceAll("\\.", "/"));
        NONPRIMITIVE_MAP.put(Integer.TYPE, Integer.class.getName().replaceAll("\\.", "/"));
        NONPRIMITIVE_MAP.put(Short.TYPE, Short.class.getName().replaceAll("\\.", "/"));
        NONPRIMITIVE_MAP.put(Character.TYPE, Character.class.getName().replaceAll("\\.", "/"));
        NONPRIMITIVE_MAP.put(Float.TYPE, Float.class.getName().replaceAll("\\.", "/"));
        NONPRIMITIVE_MAP.put(Double.TYPE, Double.class.getName().replaceAll("\\.", "/"));
    }
}

