/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.tests.codecs.bloom;

import java.io.IOException;
import org.apache.lucene.codecs.FieldsConsumer;
import org.apache.lucene.codecs.FieldsProducer;
import org.apache.lucene.codecs.PostingsFormat;
import org.apache.lucene.codecs.bloom.BloomFilterFactory;
import org.apache.lucene.codecs.bloom.BloomFilteringPostingsFormat;
import org.apache.lucene.codecs.bloom.FuzzySet;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.SegmentReadState;
import org.apache.lucene.index.SegmentWriteState;
import org.apache.lucene.tests.util.TestUtil;

public final class TestBloomFilteredLucenePostings
extends PostingsFormat {
    private BloomFilteringPostingsFormat delegate = new BloomFilteringPostingsFormat(TestUtil.getDefaultPostingsFormat(), (BloomFilterFactory)new LowMemoryBloomFactory());

    public TestBloomFilteredLucenePostings() {
        super("TestBloomFilteredLucenePostings");
    }

    public FieldsConsumer fieldsConsumer(SegmentWriteState state) throws IOException {
        return this.delegate.fieldsConsumer(state);
    }

    public FieldsProducer fieldsProducer(SegmentReadState state) throws IOException {
        return this.delegate.fieldsProducer(state);
    }

    public String toString() {
        return "TestBloomFilteredLucenePostings(" + String.valueOf(this.delegate) + ")";
    }

    static class LowMemoryBloomFactory
    extends BloomFilterFactory {
        LowMemoryBloomFactory() {
        }

        public FuzzySet getSetForField(SegmentWriteState state, FieldInfo info) {
            return FuzzySet.createSetBasedOnMaxMemory((int)1024);
        }

        public boolean isSaturated(FuzzySet bloomFilter, FieldInfo fieldInfo) {
            return false;
        }
    }
}

