/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.bitvectors;

import java.io.IOException;
import org.apache.lucene.codecs.hnsw.FlatVectorsScorer;
import org.apache.lucene.index.ByteVectorValues;
import org.apache.lucene.index.KnnVectorValues;
import org.apache.lucene.index.VectorSimilarityFunction;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.VectorUtil;
import org.apache.lucene.util.hnsw.RandomVectorScorer;
import org.apache.lucene.util.hnsw.RandomVectorScorerSupplier;
import org.apache.lucene.util.hnsw.UpdateableRandomVectorScorer;

public class FlatBitVectorsScorer
implements FlatVectorsScorer {
    public RandomVectorScorerSupplier getRandomVectorScorerSupplier(VectorSimilarityFunction similarityFunction, KnnVectorValues vectorValues) throws IOException {
        if (vectorValues instanceof ByteVectorValues) {
            ByteVectorValues byteVectorValues = (ByteVectorValues)vectorValues;
            return new BitRandomVectorScorerSupplier(byteVectorValues);
        }
        throw new IllegalArgumentException("vectorValues must be an instance of ByteVectorValues");
    }

    public RandomVectorScorer getRandomVectorScorer(VectorSimilarityFunction similarityFunction, KnnVectorValues vectorValues, float[] target) throws IOException {
        throw new IllegalArgumentException("bit vectors do not support float[] targets");
    }

    public RandomVectorScorer getRandomVectorScorer(VectorSimilarityFunction similarityFunction, KnnVectorValues vectorValues, byte[] target) throws IOException {
        if (vectorValues instanceof ByteVectorValues) {
            ByteVectorValues byteVectorValues = (ByteVectorValues)vectorValues;
            return new BitRandomVectorScorer(byteVectorValues, target);
        }
        throw new IllegalArgumentException("vectorValues must be an instance of ByteVectorValues");
    }

    public String toString() {
        return "FlatBitVectorsScorer()";
    }

    static class BitRandomVectorScorerSupplier
    implements RandomVectorScorerSupplier {
        protected final ByteVectorValues vectorValues;
        protected final ByteVectorValues targetVectors;

        public BitRandomVectorScorerSupplier(ByteVectorValues vectorValues) throws IOException {
            this.vectorValues = vectorValues;
            this.targetVectors = vectorValues.copy();
        }

        public UpdateableRandomVectorScorer scorer() throws IOException {
            byte[] query = new byte[this.vectorValues.dimension()];
            return new BitRandomVectorScorer(this.vectorValues, query);
        }

        public RandomVectorScorerSupplier copy() throws IOException {
            return new BitRandomVectorScorerSupplier(this.vectorValues);
        }
    }

    static class BitRandomVectorScorer
    implements UpdateableRandomVectorScorer {
        private final ByteVectorValues vectorValues;
        private final int bitDimensions;
        private final byte[] query;

        BitRandomVectorScorer(ByteVectorValues vectorValues, byte[] query) {
            this.query = query;
            this.bitDimensions = vectorValues.dimension() * 8;
            this.vectorValues = vectorValues;
        }

        public float score(int node) throws IOException {
            return (float)(this.bitDimensions - VectorUtil.xorBitCount((byte[])this.query, (byte[])this.vectorValues.vectorValue(node))) / (float)this.bitDimensions;
        }

        public int maxOrd() {
            return this.vectorValues.size();
        }

        public void setScoringOrdinal(int node) throws IOException {
            System.arraycopy(this.vectorValues.vectorValue(node), 0, this.query, 0, this.query.length);
        }

        public int ordToDoc(int ord) {
            return this.vectorValues.ordToDoc(ord);
        }

        public Bits getAcceptOrds(Bits acceptDocs) {
            return this.vectorValues.getAcceptOrds(acceptDocs);
        }
    }
}

