/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.session;

import javax.jcr.AccessDeniedException;
import javax.jcr.ItemExistsException;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.nodetype.ConstraintViolationException;
import org.apache.jackrabbit.core.ItemManager;
import org.apache.jackrabbit.core.NodeImpl;
import org.apache.jackrabbit.core.id.NodeId;
import org.apache.jackrabbit.core.session.SessionContext;
import org.apache.jackrabbit.core.session.SessionWriteOperation;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.Path;
import org.apache.jackrabbit.spi.commons.conversion.NameException;
import org.apache.jackrabbit.spi.commons.name.PathFactoryImpl;

public class AddNodeOperation
implements SessionWriteOperation<Node> {
    private final NodeImpl node;
    private final String relPath;
    private final String nodeTypeName;
    private final String uuid;

    public AddNodeOperation(NodeImpl node, String relPath, String nodeTypeName, String uuid) {
        this.node = node;
        this.relPath = relPath;
        this.nodeTypeName = nodeTypeName;
        this.uuid = uuid;
    }

    @Override
    public Node perform(SessionContext context) throws RepositoryException {
        NodeImpl parentNode;
        Path path;
        ItemManager itemMgr = context.getItemManager();
        try {
            path = PathFactoryImpl.getInstance().create(this.node.getPrimaryPath(), context.getQPath(this.relPath), true);
        }
        catch (NameException e) {
            throw new RepositoryException("Failed to resolve path " + this.relPath + " relative to " + String.valueOf(this.node), (Throwable)e);
        }
        if (!path.denotesName() || path.getIndex() != 0) {
            throw new RepositoryException("Invalid last path element for adding node " + this.relPath + " relative to " + String.valueOf(this.node));
        }
        Path parentPath = path.getAncestor(1);
        try {
            parentNode = itemMgr.getNode(parentPath);
        }
        catch (PathNotFoundException e) {
            if (itemMgr.propertyExists(parentPath)) {
                throw new ConstraintViolationException("Unable to add a child node to property " + context.getJCRPath(parentPath));
            }
            throw e;
        }
        catch (AccessDeniedException ade) {
            throw new PathNotFoundException("Failed to resolve path " + this.relPath + " relative to " + String.valueOf(this.node));
        }
        Name typeName = null;
        if (this.nodeTypeName != null) {
            typeName = context.getQName(this.nodeTypeName);
        }
        NodeId id = null;
        if (this.uuid != null && itemMgr.itemExists(id = new NodeId(this.uuid))) {
            throw new ItemExistsException("A node with this UUID already exists: " + this.uuid);
        }
        return parentNode.addNode(path.getName(), typeName, id);
    }

    public String toString() {
        return "node.addNode(" + this.relPath + ", " + this.nodeTypeName + ", " + this.uuid + ")";
    }
}

