/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.commons;

import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import java.util.function.UnaryOperator;
import javax.jcr.NamespaceException;
import javax.jcr.NamespaceRegistry;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.jackrabbit.util.XMLChar;

public class NamespaceHelper {
    public static final String JCR = "http://www.jcp.org/jcr/1.0";
    public static final String NT = "http://www.jcp.org/jcr/nt/1.0";
    public static final String MIX = "http://www.jcp.org/jcr/mix/1.0";
    private final Session session;
    private NamespaceRegistry namespaceRegistry;
    private static final Map<String, String> KNOWN_PREFIXES = Map.of("http://creativecommons.org/ns#", "cc", "http://purl.org/dc/terms/", "dc", "http://ns.adobe.com/DICOM/", "DICOM", "http://ns.adobe.com/exif/1.0/", "exif", "http://ns.adobe.com/pdf/1.3/", "pdf", "http://ns.adobe.com/pdfx/1.3/", "pdfx", "http://ns.adobe.com/photoshop/1.0/", "photoshop", "http://www.w3.org/1999/02/22-rdf-syntax-ns#", "rdf", "http://ns.adobe.com/tiff/1.0/", "tiff", "http://ns.adobe.com/xap/1.0/", "xmp");

    public NamespaceHelper(Session session) {
        this.session = session;
        this.namespaceRegistry = null;
    }

    private NamespaceRegistry getNamespaceRegistry() throws RepositoryException {
        if (this.namespaceRegistry == null) {
            this.namespaceRegistry = this.session.getWorkspace().getNamespaceRegistry();
        }
        return this.namespaceRegistry;
    }

    public Map<String, String> getNamespaces() throws RepositoryException {
        String[] prefixes;
        HashMap<String, String> namespaces = new HashMap<String, String>();
        for (String prefix : prefixes = this.session.getNamespacePrefixes()) {
            namespaces.put(prefix, this.session.getNamespaceURI(prefix));
        }
        return namespaces;
    }

    public String getPrefix(String uri) throws RepositoryException {
        try {
            return this.session.getNamespacePrefix(uri);
        }
        catch (NamespaceException e) {
            return null;
        }
    }

    public String getURI(String prefix) throws RepositoryException {
        try {
            return this.session.getNamespaceURI(prefix);
        }
        catch (NamespaceException e) {
            return null;
        }
    }

    public String getJcrName(String uri, String name) throws NamespaceException, RepositoryException {
        if (uri != null && !uri.isEmpty()) {
            return this.session.getNamespacePrefix(uri) + ":" + name;
        }
        return name;
    }

    public String getJcrName(String name) throws IllegalArgumentException, RepositoryException {
        String currentPrefix;
        String standardPrefix;
        if (name.startsWith("jcr:")) {
            standardPrefix = "jcr";
            currentPrefix = this.session.getNamespacePrefix(JCR);
        } else if (name.startsWith("nt:")) {
            standardPrefix = "nt";
            currentPrefix = this.session.getNamespacePrefix(NT);
        } else if (name.startsWith("mix:")) {
            standardPrefix = "mix";
            currentPrefix = this.session.getNamespacePrefix(MIX);
        } else {
            throw new IllegalArgumentException("Unknown prefix: " + name);
        }
        if (currentPrefix.equals(standardPrefix)) {
            return name;
        }
        return currentPrefix + name.substring(standardPrefix.length());
    }

    public String registerNamespace(String prefix, String uri) throws RepositoryException {
        NamespaceRegistry registry = this.getNamespaceRegistry();
        try {
            registry.getPrefix(uri);
        }
        catch (NamespaceException e1) {
            if (prefix == null || prefix.isEmpty() || prefix.toLowerCase().startsWith("xml") || !XMLChar.isValidNCName(prefix)) {
                prefix = null;
            }
            if (prefix == null) {
                prefix = NamespaceHelper.suggestPrefix(uri, pref -> {
                    try {
                        return registry.getURI(pref);
                    }
                    catch (RepositoryException e) {
                        return null;
                    }
                });
            }
            try {
                registry.registerNamespace(prefix, uri);
            }
            catch (NamespaceException ex) {
                return this.registerNamespace(null, uri);
            }
        }
        return this.session.getNamespacePrefix(uri);
    }

    public void registerNamespaces(Map<String, String> namespaces) throws RepositoryException {
        for (Map.Entry<String, String> entry : namespaces.entrySet()) {
            this.registerNamespace(entry.getKey(), entry.getValue());
        }
    }

    private static String devisePrefixByUUID(String namespace, UnaryOperator<String> lookupNamespace) {
        String prefix;
        while (namespace.equals(lookupNamespace.apply(prefix = "u-" + String.valueOf(UUID.randomUUID())))) {
        }
        return prefix;
    }

    private static String getSha256(String namespace) {
        try {
            byte[] bytes = MessageDigest.getInstance("SHA-256").digest(namespace.getBytes(StandardCharsets.UTF_8));
            return new BigInteger(1, bytes).toString(16);
        }
        catch (NoSuchAlgorithmException e) {
            return null;
        }
    }

    private static String devisePrefixTrySha256(String namespace, UnaryOperator<String> lookupNamespace) {
        String sha = NamespaceHelper.getSha256(namespace);
        if (sha != null) {
            for (int i = 7; i <= sha.length(); ++i) {
                String prefix = "s-" + sha.substring(0, i);
                String lookedUpPrefix = (String)lookupNamespace.apply(prefix);
                if (lookedUpPrefix != null) continue;
                return prefix;
            }
        }
        return NamespaceHelper.devisePrefixByUUID(namespace, lookupNamespace);
    }

    private static String devisePrefix(String namespace, UnaryOperator<String> lookupNamespace) {
        String prefix = namespace.toLowerCase(Locale.ENGLISH);
        if (prefix.startsWith("http://")) {
            prefix = prefix.substring("http://".length());
        } else if (prefix.startsWith("https://")) {
            prefix = prefix.substring("https://".length());
        }
        if (prefix.startsWith("www.")) {
            prefix = prefix.substring("www.".length());
        } else if (prefix.startsWith("ns.")) {
            prefix = prefix.substring("ns.".length());
        }
        prefix = prefix.replaceAll("[\\/:]+", "-");
        while (prefix.endsWith("-")) {
            prefix = prefix.substring(0, prefix.length() - 1);
        }
        String lookedUpNamespace = (String)lookupNamespace.apply(prefix);
        if (lookedUpNamespace == null || lookedUpNamespace.equals(namespace)) {
            return prefix;
        }
        return NamespaceHelper.devisePrefixTrySha256(namespace, lookupNamespace);
    }

    private static String suggestPrefix(String namespace, UnaryOperator<String> lookupPrefix) {
        String lookedUpNamespace;
        String known = KNOWN_PREFIXES.get(namespace);
        String string = lookedUpNamespace = known != null ? (String)lookupPrefix.apply(known) : null;
        if (known != null && (lookedUpNamespace == null || namespace.equals(lookedUpNamespace))) {
            return known;
        }
        return NamespaceHelper.devisePrefix(namespace, lookupPrefix);
    }
}

