/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.security.user;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import org.apache.jackrabbit.api.security.user.Authorizable;
import org.apache.jackrabbit.api.security.user.QueryBuilder;

public class XPathQueryBuilder
implements QueryBuilder<Condition> {
    private Class<? extends Authorizable> selector = Authorizable.class;
    private String groupName;
    private boolean declaredMembersOnly;
    private Condition condition;
    private String sortProperty;
    private QueryBuilder.Direction sortDirection = QueryBuilder.Direction.ASCENDING;
    private boolean sortIgnoreCase;
    private Value bound;
    private long offset;
    private long maxCount = -1L;

    Class<? extends Authorizable> getSelector() {
        return this.selector;
    }

    public String getGroupName() {
        return this.groupName;
    }

    public boolean isDeclaredMembersOnly() {
        return this.declaredMembersOnly;
    }

    Condition getCondition() {
        return this.condition;
    }

    String getSortProperty() {
        return this.sortProperty;
    }

    QueryBuilder.Direction getSortDirection() {
        return this.sortDirection;
    }

    boolean getSortIgnoreCase() {
        return this.sortIgnoreCase;
    }

    Value getBound() {
        return this.bound;
    }

    long getOffset() {
        return this.offset;
    }

    long getMaxCount() {
        return this.maxCount;
    }

    public void setSelector(Class<? extends Authorizable> selector) {
        this.selector = selector;
    }

    public void setScope(String groupName, boolean declaredOnly) {
        this.groupName = groupName;
        this.declaredMembersOnly = declaredOnly;
    }

    public void setCondition(Condition condition) {
        this.condition = condition;
    }

    public void setSortOrder(String propertyName, QueryBuilder.Direction direction, boolean ignoreCase) {
        this.sortProperty = propertyName;
        this.sortDirection = direction;
        this.sortIgnoreCase = ignoreCase;
    }

    public void setSortOrder(String propertyName, QueryBuilder.Direction direction) {
        this.setSortOrder(propertyName, direction, false);
    }

    public void setLimit(Value bound, long maxCount) {
        this.offset = 0L;
        this.bound = bound;
        this.maxCount = maxCount;
    }

    public void setLimit(long offset, long maxCount) {
        this.bound = null;
        this.offset = offset;
        this.maxCount = maxCount;
    }

    public Condition property(String relPath, RelationOp op, Value value) {
        return new PropertyCondition(relPath, op, value);
    }

    public Condition nameMatches(String pattern) {
        return new NodeCondition(pattern);
    }

    public Condition neq(String relPath, Value value) {
        return new PropertyCondition(relPath, RelationOp.NE, value);
    }

    public Condition eq(String relPath, Value value) {
        return new PropertyCondition(relPath, RelationOp.EQ, value);
    }

    public Condition lt(String relPath, Value value) {
        return new PropertyCondition(relPath, RelationOp.LT, value);
    }

    public Condition le(String relPath, Value value) {
        return new PropertyCondition(relPath, RelationOp.LE, value);
    }

    public Condition gt(String relPath, Value value) {
        return new PropertyCondition(relPath, RelationOp.GT, value);
    }

    public Condition ge(String relPath, Value value) {
        return new PropertyCondition(relPath, RelationOp.GE, value);
    }

    public Condition exists(String relPath) {
        return new PropertyCondition(relPath, RelationOp.EX);
    }

    public Condition like(String relPath, String pattern) {
        return new PropertyCondition(relPath, RelationOp.LIKE, pattern);
    }

    public Condition contains(String relPath, String searchExpr) {
        return new ContainsCondition(relPath, searchExpr);
    }

    public Condition impersonates(String name) {
        return new ImpersonationCondition(name);
    }

    public Condition not(Condition condition) {
        return new NotCondition(condition);
    }

    public Condition and(Condition condition1, Condition condition2) {
        return new AndCondition(condition1, condition2);
    }

    public Condition or(Condition condition1, Condition condition2) {
        return new OrCondition(condition1, condition2);
    }

    static interface Condition {
        public void accept(ConditionVisitor var1) throws RepositoryException;
    }

    static class PropertyCondition
    implements Condition {
        private final String relPath;
        private final RelationOp op;
        private final Value value;
        private final String pattern;

        public PropertyCondition(String relPath, RelationOp op, Value value) {
            this.relPath = relPath;
            this.op = op;
            this.value = value;
            this.pattern = null;
        }

        public PropertyCondition(String relPath, RelationOp op, String pattern) {
            this.relPath = relPath;
            this.op = op;
            this.value = null;
            this.pattern = pattern;
        }

        public PropertyCondition(String relPath, RelationOp op) {
            this.relPath = relPath;
            this.op = op;
            this.value = null;
            this.pattern = null;
        }

        public String getRelPath() {
            return this.relPath;
        }

        public RelationOp getOp() {
            return this.op;
        }

        public Value getValue() {
            return this.value;
        }

        public String getPattern() {
            return this.pattern;
        }

        @Override
        public void accept(ConditionVisitor visitor) throws RepositoryException {
            visitor.visit(this);
        }
    }

    static enum RelationOp {
        NE("!="),
        EQ("="),
        LT("<"),
        LE("<="),
        GT(">"),
        GE("=>"),
        EX(""),
        LIKE("like");

        private final String op;

        private RelationOp(String op) {
            this.op = op;
        }

        public String getOp() {
            return this.op;
        }
    }

    static class NodeCondition
    implements Condition {
        private final String pattern;

        public NodeCondition(String pattern) {
            this.pattern = pattern;
        }

        public String getPattern() {
            return this.pattern;
        }

        @Override
        public void accept(ConditionVisitor visitor) throws RepositoryException {
            visitor.visit(this);
        }
    }

    static class ContainsCondition
    implements Condition {
        private final String relPath;
        private final String searchExpr;

        public ContainsCondition(String relPath, String searchExpr) {
            this.relPath = relPath;
            this.searchExpr = searchExpr;
        }

        public String getRelPath() {
            return this.relPath;
        }

        public String getSearchExpr() {
            return this.searchExpr;
        }

        @Override
        public void accept(ConditionVisitor visitor) {
            visitor.visit(this);
        }
    }

    static class ImpersonationCondition
    implements Condition {
        private final String name;

        public ImpersonationCondition(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        @Override
        public void accept(ConditionVisitor visitor) {
            visitor.visit(this);
        }
    }

    static class NotCondition
    implements Condition {
        private final Condition condition;

        public NotCondition(Condition condition) {
            this.condition = condition;
        }

        public Condition getCondition() {
            return this.condition;
        }

        @Override
        public void accept(ConditionVisitor visitor) throws RepositoryException {
            visitor.visit(this);
        }
    }

    static class AndCondition
    extends CompoundCondition {
        public AndCondition(Condition condition1, Condition condition2) {
            super(condition1, condition2);
        }

        @Override
        public void accept(ConditionVisitor visitor) throws RepositoryException {
            visitor.visit(this);
        }
    }

    static class OrCondition
    extends CompoundCondition {
        public OrCondition(Condition condition1, Condition condition2) {
            super(condition1, condition2);
        }

        @Override
        public void accept(ConditionVisitor visitor) throws RepositoryException {
            visitor.visit(this);
        }
    }

    static abstract class CompoundCondition
    implements Condition,
    Iterable<Condition> {
        private final List<Condition> conditions = new ArrayList<Condition>();

        public CompoundCondition() {
        }

        public CompoundCondition(Condition condition1, Condition condition2) {
            this.conditions.add(condition1);
            this.conditions.add(condition2);
        }

        public void addCondition(Condition condition) {
            this.conditions.add(condition);
        }

        @Override
        public Iterator<Condition> iterator() {
            return this.conditions.iterator();
        }
    }

    static interface ConditionVisitor {
        public void visit(NodeCondition var1) throws RepositoryException;

        public void visit(PropertyCondition var1) throws RepositoryException;

        public void visit(ContainsCondition var1);

        public void visit(ImpersonationCondition var1);

        public void visit(NotCondition var1) throws RepositoryException;

        public void visit(AndCondition var1) throws RepositoryException;

        public void visit(OrCondition var1) throws RepositoryException;
    }
}

