/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.security.authorization;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public class PrivilegeBits {
    public static final PrivilegeBits EMPTY = new PrivilegeBits(UnmodifiableData.EMPTY);
    private static final long READ = 1L;
    private static final Map<Long, PrivilegeBits> BUILT_IN = new HashMap<Long, PrivilegeBits>();
    private final Data d;

    private PrivilegeBits(Data d) {
        this.d = d;
    }

    long longValue() {
        return this.d.longValue();
    }

    PrivilegeBits nextBits() {
        if (this == EMPTY) {
            return EMPTY;
        }
        PrivilegeBits pb = new PrivilegeBits(this.d.next());
        if (pb.d.isSimple()) {
            BUILT_IN.put(pb.longValue(), pb);
        }
        return pb;
    }

    static PrivilegeBits getInstance(long bits) {
        if (bits == 0L) {
            return EMPTY;
        }
        if (bits < 0L) {
            throw new IllegalArgumentException();
        }
        PrivilegeBits pb = BUILT_IN.get(bits);
        if (pb == null) {
            pb = new PrivilegeBits(new UnmodifiableData(bits));
            BUILT_IN.put(bits, pb);
        }
        return pb;
    }

    private static PrivilegeBits getInstance(long[] bits) {
        long[] bts = new long[bits.length];
        System.arraycopy(bits, 0, bts, 0, bits.length);
        return new PrivilegeBits(new UnmodifiableData(bts));
    }

    public static PrivilegeBits getInstance() {
        return new PrivilegeBits(new ModifiableData());
    }

    public static PrivilegeBits getInstance(PrivilegeBits base) {
        return new PrivilegeBits(new ModifiableData(base.d));
    }

    public boolean isEmpty() {
        return this.d.isEmpty();
    }

    public PrivilegeBits unmodifiable() {
        if (this.d instanceof ModifiableData) {
            return this.d.isSimple() ? PrivilegeBits.getInstance(this.d.longValue()) : PrivilegeBits.getInstance(this.d.longValues());
        }
        return this;
    }

    public boolean isModifiable() {
        return this.d instanceof ModifiableData;
    }

    public boolean includesRead() {
        if (this == EMPTY) {
            return false;
        }
        return this.d.includesRead();
    }

    public boolean includes(PrivilegeBits otherBits) {
        return this.d.includes(otherBits.d);
    }

    public void add(PrivilegeBits other) {
        if (!(this.d instanceof ModifiableData)) {
            throw new UnsupportedOperationException("immutable privilege bits");
        }
        ((ModifiableData)this.d).add(other.d);
    }

    public void diff(PrivilegeBits other) {
        if (!(this.d instanceof ModifiableData)) {
            throw new UnsupportedOperationException("immutable privilege bits");
        }
        ((ModifiableData)this.d).diff(other.d);
    }

    public void addDifference(PrivilegeBits a, PrivilegeBits b) {
        if (!(this.d instanceof ModifiableData)) {
            throw new UnsupportedOperationException("immutable privilege bits");
        }
        ((ModifiableData)this.d).addDifference(a.d, b.d);
    }

    public int hashCode() {
        return this.d.hashCode();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof PrivilegeBits) {
            return this.d.equals(((PrivilegeBits)o).d);
        }
        return false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("PrivilegeBits: ");
        if (this.d.isSimple()) {
            sb.append(this.d.longValue());
        } else {
            sb.append(Arrays.toString(this.d.longValues()));
        }
        return sb.toString();
    }

    static {
        BUILT_IN.put(EMPTY.longValue(), EMPTY);
    }

    private static abstract class Data {
        private Data() {
        }

        abstract boolean isEmpty();

        abstract long longValue();

        abstract long[] longValues();

        abstract boolean isSimple();

        abstract Data next();

        abstract boolean includes(Data var1);

        abstract boolean includesRead();

        boolean equalData(Data d) {
            if (this.isSimple() != d.isSimple()) {
                return false;
            }
            if (this.isSimple()) {
                return this.longValue() == d.longValue();
            }
            return Arrays.equals(this.longValues(), d.longValues());
        }

        static boolean includes(long bits, long otherBits) {
            return (bits | otherBits ^ 0xFFFFFFFFFFFFFFFFL) == -1L;
        }

        static boolean includes(long[] bits, long[] otherBits) {
            if (otherBits.length <= bits.length) {
                for (int i = 0; i < otherBits.length; ++i) {
                    if ((bits[i] | otherBits[i] ^ 0xFFFFFFFFFFFFFFFFL) == -1L) continue;
                    return false;
                }
                return true;
            }
            return false;
        }
    }

    private static class UnmodifiableData
    extends Data {
        private static final long MAX = 0x3FFFFFFFFFFFFFFFL;
        private static final UnmodifiableData EMPTY = new UnmodifiableData(0L);
        private final long bits;
        private final long[] bitsArr;
        private final boolean isSimple;
        private final boolean includesRead;

        private UnmodifiableData(long bits) {
            this.bits = bits;
            this.bitsArr = new long[]{bits};
            this.isSimple = true;
            this.includesRead = (bits & 1L) == 1L;
        }

        private UnmodifiableData(long[] bitsArr) {
            this.bits = 0L;
            this.bitsArr = bitsArr;
            this.isSimple = false;
            this.includesRead = (bitsArr[0] & 1L) == 1L;
        }

        @Override
        boolean isEmpty() {
            return this == EMPTY;
        }

        @Override
        long longValue() {
            return this.bits;
        }

        @Override
        long[] longValues() {
            return this.bitsArr;
        }

        @Override
        boolean isSimple() {
            return this.isSimple;
        }

        @Override
        Data next() {
            long[] bts;
            if (this == EMPTY) {
                return EMPTY;
            }
            if (this.isSimple) {
                if (this.bits < 0x3FFFFFFFFFFFFFFFL) {
                    long b = this.bits << 1;
                    return new UnmodifiableData(b);
                }
                return new UnmodifiableData(new long[]{this.bits}).next();
            }
            long last = this.bitsArr[this.bitsArr.length - 1];
            if (last < 0x3FFFFFFFFFFFFFFFL) {
                bts = new long[this.bitsArr.length];
                System.arraycopy(this.bitsArr, 0, bts, 0, this.bitsArr.length);
                bts[bts.length - 1] = last << 1;
            } else {
                bts = new long[this.bitsArr.length + 1];
                bts[bts.length - 1] = 1L;
            }
            return new UnmodifiableData(bts);
        }

        @Override
        boolean includes(Data other) {
            if (this.isSimple) {
                return other.isSimple() ? UnmodifiableData.includes(this.bits, other.longValue()) : false;
            }
            return UnmodifiableData.includes(this.bitsArr, other.longValues());
        }

        @Override
        boolean includesRead() {
            return this.includesRead;
        }

        public int hashCode() {
            return this.isSimple ? new Long(this.bits).hashCode() : Arrays.hashCode(this.bitsArr);
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof UnmodifiableData) {
                UnmodifiableData d = (UnmodifiableData)o;
                if (this.isSimple != d.isSimple) {
                    return false;
                }
                if (this.isSimple) {
                    return this.bits == d.bits;
                }
                return Arrays.equals(this.bitsArr, d.bitsArr);
            }
            if (o instanceof ModifiableData) {
                return this.equalData((Data)o);
            }
            return false;
        }
    }

    private static class ModifiableData
    extends Data {
        private long[] bits;

        private ModifiableData() {
            this.bits = new long[]{0L};
        }

        private ModifiableData(Data base) {
            long[] b = base.longValues();
            switch (b.length) {
                case 0: {
                    this.bits = new long[]{0L};
                    break;
                }
                case 1: {
                    this.bits = new long[]{b[0]};
                    break;
                }
                default: {
                    this.bits = new long[b.length];
                    System.arraycopy(b, 0, this.bits, 0, b.length);
                }
            }
        }

        @Override
        boolean isEmpty() {
            return this.bits.length == 1 && this.bits[0] == 0L;
        }

        @Override
        long longValue() {
            return this.bits.length == 1 ? this.bits[0] : 0L;
        }

        @Override
        long[] longValues() {
            return this.bits;
        }

        @Override
        boolean isSimple() {
            return this.bits.length == 1;
        }

        @Override
        Data next() {
            throw new UnsupportedOperationException("Not implemented.");
        }

        @Override
        boolean includes(Data other) {
            if (this.bits.length == 1) {
                return other.isSimple() && ModifiableData.includes(this.bits[0], other.longValue());
            }
            return ModifiableData.includes(this.bits, other.longValues());
        }

        @Override
        boolean includesRead() {
            return (this.bits[0] & 1L) == 1L;
        }

        private void add(Data other) {
            if (other != this) {
                if (this.bits.length == 1 && other.isSimple()) {
                    this.bits[0] = this.bits[0] | other.longValue();
                } else {
                    this.or(other.longValues());
                }
            }
        }

        private void diff(Data other) {
            if (this.bits.length == 1 && other.isSimple()) {
                this.bits[0] = this.bits[0] & (other.longValue() ^ 0xFFFFFFFFFFFFFFFFL);
            } else {
                this.bits = ModifiableData.diff(this.bits, other.longValues());
            }
        }

        private void addDifference(Data a, Data b) {
            if (a.isSimple() && b.isSimple()) {
                this.bits[0] = this.bits[0] | a.longValue() & (b.longValue() ^ 0xFFFFFFFFFFFFFFFFL);
            } else {
                long[] diff = ModifiableData.diff(a.longValues(), b.longValues());
                this.or(diff);
            }
        }

        private void or(long[] b) {
            if (b.length > this.bits.length) {
                long[] res = new long[b.length];
                System.arraycopy(this.bits, 0, res, 0, this.bits.length);
                this.bits = res;
            }
            for (int i = 0; i < b.length; ++i) {
                int n = i;
                this.bits[n] = this.bits[n] | b[i];
            }
        }

        private static long[] diff(long[] a, long[] b) {
            int index = -1;
            long[] res = new long[a.length > b.length ? a.length : b.length];
            for (int i = 0; i < res.length; ++i) {
                if (i < a.length && i < b.length) {
                    res[i] = a[i] & (b[i] ^ 0xFFFFFFFFFFFFFFFFL);
                } else {
                    long l = res[i] = i < a.length ? a[i] : 0L;
                }
                if (res[i] != 0L) {
                    index = -1;
                    continue;
                }
                if (index != -1) continue;
                index = i;
            }
            switch (index) {
                case -1: {
                    return res;
                }
                case 0: {
                    return new long[]{0L};
                }
            }
            long[] r2 = new long[index];
            System.arraycopy(res, 0, r2, 0, index);
            return r2;
        }

        public int hashCode() {
            return 0;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof ModifiableData) {
                ModifiableData d = (ModifiableData)o;
                return Arrays.equals(this.bits, d.bits);
            }
            if (o instanceof UnmodifiableData) {
                return this.equalData((Data)o);
            }
            return false;
        }
    }
}

