/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.lock;

import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.lock.Lock;
import javax.jcr.lock.LockException;
import org.apache.jackrabbit.core.NodeImpl;
import org.apache.jackrabbit.core.SessionImpl;
import org.apache.jackrabbit.core.lock.LockInfo;
import org.apache.jackrabbit.core.lock.LockManager;
import org.apache.jackrabbit.core.lock.LockManagerImpl;
import org.apache.jackrabbit.core.lock.XAEnvironment;
import org.apache.jackrabbit.core.lock.XALockImpl;
import org.apache.jackrabbit.data.core.InternalXAResource;
import org.apache.jackrabbit.data.core.TransactionContext;
import org.apache.jackrabbit.data.core.TransactionException;
import org.apache.jackrabbit.spi.Path;

public class XALockManager
implements LockManager,
InternalXAResource {
    private static final String XA_ENV_ATTRIBUTE_NAME = "XALockManager.XAEnv";
    private final LockManagerImpl lockMgr;
    private XAEnvironment xaEnv;

    public XALockManager(LockManagerImpl lockMgr) {
        this.lockMgr = lockMgr;
    }

    @Override
    public Lock lock(NodeImpl node, boolean isDeep, boolean isSessionScoped) throws LockException, RepositoryException {
        return this.lock(node, isDeep, isSessionScoped, Long.MAX_VALUE, null);
    }

    @Override
    public Lock lock(NodeImpl node, boolean isDeep, boolean isSessionScoped, long timoutHint, String ownerInfo) throws LockException, RepositoryException {
        LockInfo info = this.isInXA() ? this.xaEnv.lock(node, isDeep, isSessionScoped, timoutHint, ownerInfo) : this.lockMgr.internalLock(node, isDeep, isSessionScoped, timoutHint, ownerInfo);
        this.lockMgr.writeLockProperties(node, info.getLockOwner(), info.isDeep());
        return new XALockImpl(this, info, node);
    }

    @Override
    public Lock getLock(NodeImpl node) throws LockException, RepositoryException {
        LockInfo info = this.isInXA() ? this.xaEnv.getLockInfo(node) : this.lockMgr.getLockInfo(node.getNodeId());
        if (info == null) {
            throw new LockException("Node not locked: " + String.valueOf(node));
        }
        SessionImpl session = (SessionImpl)node.getSession();
        NodeImpl holder = (NodeImpl)session.getItemManager().getItem(info.getId());
        return new XALockImpl(this, info, holder);
    }

    @Override
    public Lock[] getLocks(SessionImpl session) throws RepositoryException {
        LockInfo[] infos = this.isInXA() ? this.xaEnv.getLockInfos(session) : this.lockMgr.getLockInfos(session);
        Lock[] locks = new XALockImpl[infos.length];
        for (int i = 0; i < infos.length; ++i) {
            LockInfo info = infos[i];
            NodeImpl holder = (NodeImpl)session.getItemManager().getItem(info.getId());
            locks[i] = new XALockImpl(this, info, holder);
        }
        return locks;
    }

    @Override
    public void unlock(NodeImpl node) throws LockException, RepositoryException {
        this.lockMgr.removeLockProperties(node);
        if (this.isInXA()) {
            this.xaEnv.unlock(node);
        } else {
            this.lockMgr.internalUnlock(node);
        }
    }

    @Override
    public boolean holdsLock(NodeImpl node) throws RepositoryException {
        LockInfo info = this.isInXA() ? this.xaEnv.getLockInfo(node) : this.lockMgr.getLockInfo(node.getNodeId());
        return info != null && info.getId().equals(node.getId());
    }

    @Override
    public boolean isLocked(NodeImpl node) throws RepositoryException {
        LockInfo info = this.isInXA() ? this.xaEnv.getLockInfo(node) : this.lockMgr.getLockInfo(node.getNodeId());
        return info != null;
    }

    @Override
    public void checkLock(NodeImpl node) throws LockException, RepositoryException {
        if (this.isInXA()) {
            LockInfo info = this.xaEnv.getLockInfo(node);
            if (info != null && !info.isLockHolder(node.getSession())) {
                throw new LockException("Node locked.");
            }
        } else {
            this.lockMgr.checkLock(node);
        }
    }

    @Override
    public void checkLock(Path path, Session session) throws LockException, RepositoryException {
        if (this.isInXA()) {
            SessionImpl sessionImpl = (SessionImpl)session;
            this.checkLock(sessionImpl.getItemManager().getNode(path));
        } else {
            this.lockMgr.checkLock(path, session);
        }
    }

    @Override
    public void checkUnlock(Session session, NodeImpl node) throws LockException, RepositoryException {
        if (this.isInXA()) {
            LockInfo info = this.xaEnv.getLockInfo(node);
            if (info == null || !info.getId().equals(node.getId())) {
                throw new LockException("Node not locked: " + String.valueOf(node));
            }
            if (!info.isLockHolder(session)) {
                throw new LockException("Node not locked by session: " + String.valueOf(node));
            }
        } else {
            this.lockMgr.checkUnlock(session, node);
        }
    }

    @Override
    public void addLockToken(SessionImpl session, String lt) throws RepositoryException {
        if (this.isInXA()) {
            this.xaEnv.addLockToken(session, lt);
        } else {
            this.lockMgr.addLockToken(session, lt);
        }
    }

    @Override
    public void removeLockToken(SessionImpl session, String lt) throws RepositoryException {
        if (this.isInXA()) {
            this.xaEnv.removeLockToken(session, lt);
        } else {
            this.lockMgr.removeLockToken(session, lt);
        }
    }

    public void associate(TransactionContext tx) {
        XAEnvironment xaEnv = null;
        if (tx != null && (xaEnv = (XAEnvironment)tx.getAttribute(XA_ENV_ATTRIBUTE_NAME)) == null) {
            xaEnv = new XAEnvironment(this.lockMgr);
            tx.setAttribute(XA_ENV_ATTRIBUTE_NAME, (Object)xaEnv);
        }
        this.xaEnv = xaEnv;
    }

    public void beforeOperation(TransactionContext tx) {
    }

    public void prepare(TransactionContext tx) throws TransactionException {
        XAEnvironment xaEnv = (XAEnvironment)tx.getAttribute(XA_ENV_ATTRIBUTE_NAME);
        if (xaEnv != null) {
            xaEnv.prepare();
        }
    }

    public void commit(TransactionContext tx) {
        XAEnvironment xaEnv = (XAEnvironment)tx.getAttribute(XA_ENV_ATTRIBUTE_NAME);
        if (xaEnv != null) {
            xaEnv.commit();
        }
    }

    public void rollback(TransactionContext tx) {
        XAEnvironment xaEnv = (XAEnvironment)tx.getAttribute(XA_ENV_ATTRIBUTE_NAME);
        if (xaEnv != null) {
            xaEnv.rollback();
        }
    }

    public void afterOperation(TransactionContext tx) {
    }

    public boolean differentXAEnv(LockInfo info) {
        if (this.isInXA()) {
            return this.xaEnv.differentXAEnv(info);
        }
        return info instanceof XAEnvironment.XALockInfo;
    }

    private boolean isInXA() {
        return this.xaEnv != null;
    }
}

