/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.jca;

import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.apache.jackrabbit.jca.JCAManagedConnection;

public class TransactionBoundXAResource
implements XAResource {
    private XAResource xaResource;
    private JCAManagedConnection connection;
    private boolean ending;

    public TransactionBoundXAResource(JCAManagedConnection connection, XAResource xaResource) {
        this.xaResource = xaResource;
        this.connection = connection;
    }

    protected void rebind(XAResource res) {
        this.xaResource = res;
    }

    @Override
    public void commit(Xid arg0, boolean arg1) throws XAException {
        this.xaResource.commit(arg0, arg1);
    }

    @Override
    public void end(Xid arg0, int arg1) throws XAException {
        if (!this.ending) {
            this.ending = true;
            try {
                this.xaResource.end(arg0, arg1);
            }
            finally {
                if (arg1 != 0x2000000) {
                    this.connection.closeHandles();
                }
            }
            this.ending = false;
        }
    }

    @Override
    public void forget(Xid arg0) throws XAException {
        this.xaResource.forget(arg0);
    }

    @Override
    public int getTransactionTimeout() throws XAException {
        return this.xaResource.getTransactionTimeout();
    }

    @Override
    public boolean isSameRM(XAResource arg0) throws XAException {
        return this.xaResource.isSameRM(arg0);
    }

    @Override
    public int prepare(Xid arg0) throws XAException {
        return this.xaResource.prepare(arg0);
    }

    @Override
    public Xid[] recover(int arg0) throws XAException {
        return this.xaResource.recover(arg0);
    }

    @Override
    public void rollback(Xid arg0) throws XAException {
        this.xaResource.rollback(arg0);
    }

    @Override
    public boolean setTransactionTimeout(int arg0) throws XAException {
        return this.xaResource.setTransactionTimeout(arg0);
    }

    @Override
    public void start(Xid arg0, int arg1) throws XAException {
        this.xaResource.start(arg0, arg1);
    }
}

