/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.jca;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.api.JackrabbitRepository;
import org.apache.jackrabbit.commons.JcrUtils;
import org.apache.jackrabbit.core.RepositoryImpl;
import org.apache.jackrabbit.core.config.RepositoryConfig;

public final class JCARepositoryManager {
    public static final String CLASSPATH_CONFIG_PREFIX = "classpath:";
    private static final JCARepositoryManager INSTANCE = new JCARepositoryManager();
    private final Map<Map<String, String>, Repository> repositories = new HashMap<Map<String, String>, Repository>();
    private boolean autoShutdown = true;

    private JCARepositoryManager() {
    }

    public synchronized Repository createRepository(Map<String, String> parameters) throws RepositoryException {
        Repository repository = this.repositories.get(parameters);
        if (repository == null) {
            repository = parameters.containsKey("org.apache.jackrabbit.repository.uri") ? JcrUtils.getRepository(parameters) : this.createNonTransientRepository(parameters);
            this.repositories.put(parameters, repository);
        }
        return repository;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Repository createNonTransientRepository(Map<String, String> parameters) throws RepositoryException {
        RepositoryConfig config = null;
        String configFile = parameters.get("org.apache.jackrabbit.repository.conf");
        String homeDir = parameters.get("org.apache.jackrabbit.repository.home");
        if (configFile != null && configFile.startsWith(CLASSPATH_CONFIG_PREFIX)) {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            if (cl == null) {
                cl = this.getClass().getClassLoader();
            }
            InputStream configInputStream = cl.getResourceAsStream(configFile.substring(CLASSPATH_CONFIG_PREFIX.length()));
            try {
                config = RepositoryConfig.create((InputStream)configInputStream, (String)homeDir);
            }
            finally {
                if (configInputStream != null) {
                    try {
                        configInputStream.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        config = configFile != null ? RepositoryConfig.create((String)configFile, (String)homeDir) : RepositoryConfig.create((File)new File(homeDir));
        return RepositoryImpl.create((RepositoryConfig)config);
    }

    public synchronized void shutdown() {
        for (Repository repository : this.repositories.values()) {
            if (!(repository instanceof JackrabbitRepository)) continue;
            ((JackrabbitRepository)repository).shutdown();
        }
        this.repositories.clear();
    }

    public static JCARepositoryManager getInstance() {
        return INSTANCE;
    }

    public boolean isAutoShutdown() {
        return this.autoShutdown;
    }

    public void setAutoShutdown(boolean autoShutdown) {
        this.autoShutdown = autoShutdown;
    }

    public synchronized void autoShutdownRepository(Map<String, String> parameters) {
        Repository repository;
        if (this.isAutoShutdown() && (repository = this.repositories.get(parameters)) instanceof JackrabbitRepository) {
            ((JackrabbitRepository)repository).shutdown();
        }
    }
}

