/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.jca;

import java.io.PrintWriter;
import java.util.LinkedList;
import java.util.concurrent.atomic.AtomicInteger;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionEvent;
import javax.resource.spi.ConnectionEventListener;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.LocalTransaction;
import javax.resource.spi.ManagedConnection;
import javax.resource.spi.ManagedConnectionMetaData;
import javax.security.auth.Subject;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.apache.jackrabbit.jca.JCAConnectionRequestInfo;
import org.apache.jackrabbit.jca.JCAManagedConnectionFactory;
import org.apache.jackrabbit.jca.JCASessionHandle;
import org.apache.jackrabbit.jca.TransactionBoundXAResource;

public class JCAManagedConnection
implements ManagedConnection,
ManagedConnectionMetaData {
    private final JCAManagedConnectionFactory mcf;
    private final JCAConnectionRequestInfo cri;
    private Session session;
    private XAResource xaResource;
    private final LinkedList<ConnectionEventListener> listeners;
    private final LinkedList<JCASessionHandle> handles;
    private PrintWriter logWriter;
    private LocalTransactionAdapter localTransactionAdapter;

    public JCAManagedConnection(JCAManagedConnectionFactory mcf, JCAConnectionRequestInfo cri) throws ResourceException {
        this.mcf = mcf;
        this.cri = cri;
        this.session = this.openSession();
        this.listeners = new LinkedList();
        this.handles = new LinkedList();
        this.xaResource = this.mcf.getBindSessionToTransaction() != false ? new TransactionBoundXAResource(this, (XAResource)this.session) : (XAResource)this.session;
        this.localTransactionAdapter = new LocalTransactionAdapter(this.xaResource);
    }

    private Session openSession() throws ResourceException {
        try {
            Session session = this.mcf.getRepository().login(this.cri.getCredentials(), this.cri.getWorkspace());
            this.log("Created session (" + String.valueOf(session) + ")");
            return session;
        }
        catch (RepositoryException e) {
            this.log("Failed to create session", e);
            ResourceException exception = new ResourceException("Failed to create session: " + e.getMessage());
            exception.initCause((Throwable)e);
            throw exception;
        }
    }

    public JCAManagedConnectionFactory getManagedConnectionFactory() {
        return this.mcf;
    }

    public JCAConnectionRequestInfo getConnectionRequestInfo() {
        return this.cri;
    }

    public PrintWriter getLogWriter() {
        return this.logWriter;
    }

    public void setLogWriter(PrintWriter logWriter) throws ResourceException {
        this.logWriter = logWriter;
    }

    public Object getConnection(Subject subject, ConnectionRequestInfo cri) throws ResourceException {
        JCASessionHandle handle = new JCASessionHandle(this);
        this.addHandle(handle);
        return handle;
    }

    public void destroy() throws ResourceException {
        this.session.logout();
        this.handles.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanup() throws ResourceException {
        LinkedList<JCASessionHandle> linkedList = this.handles;
        synchronized (linkedList) {
            this.session.logout();
            this.session = this.openSession();
            this.handles.clear();
            if (this.mcf.getBindSessionToTransaction().booleanValue() && this.xaResource instanceof TransactionBoundXAResource) {
                ((TransactionBoundXAResource)this.xaResource).rebind((XAResource)this.session);
            } else {
                this.xaResource = (XAResource)this.session;
            }
        }
    }

    public void associateConnection(Object connection) throws ResourceException {
        JCASessionHandle handle = (JCASessionHandle)connection;
        if (handle.getManagedConnection() != this) {
            handle.getManagedConnection().removeHandle(handle);
            handle.setManagedConnection(this);
            this.addHandle(handle);
        }
    }

    public XAResource getXAResource() throws ResourceException {
        return this.xaResource;
    }

    public LocalTransaction getLocalTransaction() throws ResourceException {
        return this.localTransactionAdapter;
    }

    public ManagedConnectionMetaData getMetaData() throws ResourceException {
        return this;
    }

    public void closeHandle(JCASessionHandle handle) {
        if (handle != null) {
            this.removeHandle(handle);
            this.sendClosedEvent(handle);
        }
    }

    public Session getSession(JCASessionHandle handle) {
        LinkedList<JCASessionHandle> linkedList = this.handles;
        synchronized (linkedList) {
            if (this.handles.size() > 0 && this.handles.get(0) == handle) {
                return this.session;
            }
            throw new IllegalStateException("Inactive logical session handle called");
        }
    }

    private String getDescriptor(String key) throws ResourceException {
        try {
            return this.mcf.getRepository().getDescriptor(key);
        }
        catch (RepositoryException e) {
            this.log("Failed to access the repository", e);
            ResourceException exception = new ResourceException("Failed to access the repository: " + e.getMessage());
            exception.initCause((Throwable)e);
            throw exception;
        }
    }

    public String getEISProductName() throws ResourceException {
        return this.getDescriptor("jcr.repository.name");
    }

    public String getEISProductVersion() throws ResourceException {
        return this.getDescriptor("jcr.repository.version");
    }

    public int getMaxConnections() throws ResourceException {
        return Integer.MAX_VALUE;
    }

    public String getUserName() throws ResourceException {
        return this.session.getUserID();
    }

    public void log(String message) {
        this.log(message, null);
    }

    public void log(String message, Throwable exception) {
        if (this.logWriter != null) {
            this.logWriter.println(message);
            if (exception != null) {
                exception.printStackTrace(this.logWriter);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addConnectionEventListener(ConnectionEventListener listener) {
        LinkedList<ConnectionEventListener> linkedList = this.listeners;
        synchronized (linkedList) {
            if (!this.listeners.contains(listener)) {
                this.listeners.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeConnectionEventListener(ConnectionEventListener listener) {
        LinkedList<ConnectionEventListener> linkedList = this.listeners;
        synchronized (linkedList) {
            this.listeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendEvent(ConnectionEvent event) {
        LinkedList<ConnectionEventListener> linkedList = this.listeners;
        synchronized (linkedList) {
            for (ConnectionEventListener listener : this.listeners) {
                switch (event.getId()) {
                    case 1: {
                        listener.connectionClosed(event);
                        break;
                    }
                    case 5: {
                        listener.connectionErrorOccurred(event);
                        break;
                    }
                    case 3: {
                        listener.localTransactionCommitted(event);
                        break;
                    }
                    case 4: {
                        listener.localTransactionRolledback(event);
                        break;
                    }
                    case 2: {
                        listener.localTransactionStarted(event);
                        break;
                    }
                }
            }
        }
    }

    private void sendEvent(int type, Object handle, Exception cause) {
        ConnectionEvent event = new ConnectionEvent((ManagedConnection)this, type, cause);
        if (handle != null) {
            event.setConnectionHandle(handle);
        }
        this.sendEvent(event);
    }

    private void sendClosedEvent(JCASessionHandle handle) {
        this.sendEvent(1, handle, null);
    }

    public void sendrrorEvent(JCASessionHandle handle, Exception cause) {
        this.sendEvent(5, handle, cause);
    }

    public void sendTxCommittedEvent(JCASessionHandle handle) {
        this.sendEvent(3, handle, null);
    }

    public void sendTxRolledbackEvent(JCASessionHandle handle) {
        this.sendEvent(4, handle, null);
    }

    public void sendTxStartedEvent(JCASessionHandle handle) {
        this.sendEvent(2, handle, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addHandle(JCASessionHandle handle) {
        LinkedList<JCASessionHandle> linkedList = this.handles;
        synchronized (linkedList) {
            this.handles.addFirst(handle);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeHandle(JCASessionHandle handle) {
        LinkedList<JCASessionHandle> linkedList = this.handles;
        synchronized (linkedList) {
            this.handles.remove(handle);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void closeHandles() {
        LinkedList<JCASessionHandle> linkedList = this.handles;
        synchronized (linkedList) {
            JCASessionHandle[] handlesArray = new JCASessionHandle[this.handles.size()];
            this.handles.toArray(handlesArray);
            for (int i = 0; i < handlesArray.length; ++i) {
                this.closeHandle(handlesArray[i]);
            }
        }
    }

    private static class LocalTransactionAdapter
    implements LocalTransaction {
        private static AtomicInteger globalCounter = new AtomicInteger();
        private XAResource resource;
        private Xid xid;

        public LocalTransactionAdapter(XAResource xaResource) {
            this.resource = xaResource;
        }

        public void begin() throws ResourceException {
            try {
                this.xid = new XidImpl(LocalTransactionAdapter.intToByteArray(globalCounter.getAndIncrement()));
                this.resource.start(this.xid, 0);
            }
            catch (XAException e) {
                throw new ResourceException(e.getMessage());
            }
        }

        public void commit() throws ResourceException {
            try {
                this.resource.end(this.xid, 0x4000000);
                this.resource.commit(this.xid, true);
            }
            catch (XAException e) {
                throw new ResourceException(e.getMessage());
            }
        }

        public void rollback() throws ResourceException {
            try {
                this.resource.end(this.xid, 0x20000000);
                this.resource.rollback(this.xid);
            }
            catch (XAException e) {
                throw new ResourceException(e.getMessage());
            }
        }

        private static byte[] intToByteArray(int value) {
            byte[] b = new byte[4];
            for (int i = 0; i < 4; ++i) {
                int offset = (b.length - 1 - i) * 8;
                b[i] = (byte)(value >>> offset & 0xFF);
            }
            return b;
        }

        class XidImpl
        implements Xid {
            private final byte[] globalTxId;

            public XidImpl(byte[] globalTxId) {
                this.globalTxId = globalTxId;
            }

            @Override
            public int getFormatId() {
                return 0;
            }

            @Override
            public byte[] getBranchQualifier() {
                return new byte[0];
            }

            @Override
            public byte[] getGlobalTransactionId() {
                return this.globalTxId;
            }
        }
    }
}

