/*
 * ====================================================================
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 * ====================================================================
 *
 * This software consists of voluntary contributions made by many
 * individuals on behalf of the Apache Software Foundation.  For more
 * information on the Apache Software Foundation, please see
 * <http://www.apache.org/>.
 *
 */
package org.apache.hc.client5.http.impl;

import org.junit.Assert;
import org.junit.Test;

public class PrefixedIncrementingIdTest {

    @Test
    public void testGetNextId() {
        final PrefixedIncrementingId testId = new PrefixedIncrementingId("test-");
        Assert.assertEquals(String.format("test-%010d", 1), testId.getNextId());
        Assert.assertEquals(String.format("test-%010d", 2), testId.getNextId());
    }

    @Test
    public void testCreateId() {
        final PrefixedIncrementingId exchangeId = new PrefixedIncrementingId("ex-");
        Assert.assertEquals(String.format("ex-%010d", 0), exchangeId.createId(0));
        for (long i = 1; i <= 100_000_000L; i *= 10) {
            Assert.assertEquals(String.format("ex-%010d", i - 1), exchangeId.createId(i - 1));
            Assert.assertEquals(String.format("ex-%010d", i), exchangeId.createId(i));
            Assert.assertEquals(String.format("ex-%010d", i + 1), exchangeId.createId(i + 1));
        }
    }

}
