/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.webconsole.plugins.useradmin.internal;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.security.MessageDigest;
import java.security.Provider;
import java.security.Security;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Iterator;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.felix.webconsole.SimpleWebConsolePlugin;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONWriter;
import org.osgi.service.useradmin.Group;
import org.osgi.service.useradmin.Role;
import org.osgi.service.useradmin.User;
import org.osgi.service.useradmin.UserAdmin;

class WebConsolePlugin
extends SimpleWebConsolePlugin {
    private static final long serialVersionUID = -3551087958597824593L;
    private static final String LABEL = "users";
    private static final String TITLE = "%role.pluginTitle";
    private static final String CATEGORY = "OSGi";
    private static final String[] CSS = new String[]{"/users/res/plugin.css"};
    private final UserAdmin userAdmin;
    private final String TEMPLATE;
    private static final String DIGEST_KEY_PREFIX = "MessageDigest.";

    WebConsolePlugin(UserAdmin userAdmin) {
        super(LABEL, TITLE, CSS);
        this.userAdmin = userAdmin;
        this.TEMPLATE = this.readTemplateFile("/res/plugin.html");
    }

    public String getCategory() {
        return CATEGORY;
    }

    protected final void renderContent(HttpServletRequest req, HttpServletResponse response) throws ServletException, IOException {
        response.getWriter().print(this.TEMPLATE);
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        resp.setContentType("application/json");
        resp.setCharacterEncoding("UTF-8");
        PrintWriter out = resp.getWriter();
        JSONWriter jw = new JSONWriter((Writer)out);
        String action = req.getParameter("action");
        String role = req.getParameter("role");
        String group = req.getParameter("group");
        try {
            if ("addMember".equals(action)) {
                Role xrole = this.userAdmin.getRole(role);
                Group xgroup = (Group)this.userAdmin.getRole(group);
                xgroup.addMember(xrole);
                WebConsolePlugin.toJSON(jw, (Role)xgroup, false);
            } else if ("addRequiredMember".equals(action)) {
                Role xrole = this.userAdmin.getRole(role);
                Group xgroup = (Group)this.userAdmin.getRole(group);
                xgroup.addRequiredMember(xrole);
                WebConsolePlugin.toJSON(jw, (Role)xgroup, false);
            } else if ("removeMember".equals(action)) {
                Role xrole = this.userAdmin.getRole(role);
                Group xgroup = (Group)this.userAdmin.getRole(group);
                xgroup.removeMember(xrole);
                WebConsolePlugin.toJSON(jw, (Role)xgroup, false);
            } else if ("toggleMembership".equals(action)) {
                Role xrole = this.userAdmin.getRole(role);
                Group xgroup = (Group)this.userAdmin.getRole(group);
                if (WebConsolePlugin.contains(xgroup.getRequiredMembers(), xrole)) {
                    xgroup.removeMember(xrole);
                    xgroup.addMember(xrole);
                } else {
                    xgroup.removeMember(xrole);
                    xgroup.addRequiredMember(xrole);
                }
                WebConsolePlugin.toJSON(jw, (Role)xgroup, false);
            } else if ("getDigestAlgorithms".equals(action)) {
                WebConsolePlugin.getMessageDigestAlgorithms(jw);
            } else if ("digest".equals(action)) {
                String dataRaw = req.getParameter("data");
                String algorithm = req.getParameter("algorithm");
                MessageDigest digest = MessageDigest.getInstance(algorithm);
                byte[] encoded = digest.digest(dataRaw.getBytes());
                jw.object();
                jw.key("encoded");
                jw.value((Object)encoded);
                jw.endObject();
            } else if ("del".equals(action)) {
                out.print(this.userAdmin.removeRole(role));
            } else if ("get".equals(action)) {
                Role xrole = this.userAdmin.getRole(role);
                WebConsolePlugin.toJSON(jw, xrole, true);
            } else if ("set".equals(action)) {
                String dataRaw = req.getParameter("data");
                JSONObject data = new JSONObject(dataRaw);
                Role xrole = this.userAdmin.getRole(data.getString("name"));
                if (null == xrole) {
                    xrole = this.userAdmin.createRole(data.getString("name"), data.getInt("type"));
                }
                WebConsolePlugin.doSetData(xrole, data);
                out.print(true);
            } else {
                Role[] roles = this.userAdmin.getRoles(null);
                WebConsolePlugin.toJSON(jw, roles, false);
            }
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
    }

    private static final void doSetData(Role role, JSONObject data) throws JSONException {
        WebConsolePlugin.putProps(role.getProperties(), data.optJSONObject("properties"));
        if (role instanceof User) {
            WebConsolePlugin.putProps(((User)role).getCredentials(), data.optJSONObject("credentials"));
        }
    }

    private static final void putProps(Dictionary dest, JSONObject props) throws JSONException {
        if (!dest.isEmpty()) {
            Enumeration e = dest.keys();
            while (e.hasMoreElements()) {
                dest.remove(e.nextElement());
            }
        }
        if (props == null || props.length() == 0) {
            return;
        }
        Iterator i = props.keys();
        while (i.hasNext()) {
            Object key = i.next();
            Object val = props.get((String)key);
            if (val instanceof JSONArray) {
                val = WebConsolePlugin.toArray((JSONArray)val);
            }
            dest.put(key, val);
        }
    }

    private static final byte[] toArray(JSONArray array) throws JSONException {
        byte[] ret = new byte[array.length()];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = (byte)(array.getInt(i) & 0xFF);
        }
        return ret;
    }

    private static final void toJSON(JSONWriter jw, Role role, boolean details) throws JSONException {
        jw.object();
        jw.key("type");
        jw.value((long)role.getType());
        jw.key("name");
        jw.value((Object)role.getName());
        if (role instanceof Group) {
            Group group = (Group)role;
            Role[] roles = group.getMembers();
            if (null != roles && roles.length > 0) {
                jw.key("members");
                WebConsolePlugin.toJSON(jw, roles, details);
            }
            if (null != (roles = group.getRequiredMembers()) && roles.length > 0) {
                jw.key("rmembers");
                WebConsolePlugin.toJSON(jw, roles, details);
            }
        }
        if (details) {
            Dictionary p = role.getProperties();
            if (null != p && !p.isEmpty()) {
                jw.key("properties");
                WebConsolePlugin.toJSON(jw, p);
            }
            if (role instanceof User && null != (p = ((User)role).getCredentials()) && !p.isEmpty()) {
                jw.key("credentials");
                WebConsolePlugin.toJSON(jw, p);
            }
        }
        jw.endObject();
    }

    private static final void toJSON(JSONWriter jw, Dictionary props) throws JSONException {
        jw.object();
        Enumeration e = props.keys();
        while (e.hasMoreElements()) {
            Object key = e.nextElement();
            Object val = props.get(key);
            jw.key((String)key);
            jw.value(val);
        }
        jw.endObject();
    }

    private static final void toJSON(JSONWriter jw, Role[] roles, boolean details) throws JSONException {
        jw.array();
        for (int i = 0; roles != null && i < roles.length; ++i) {
            WebConsolePlugin.toJSON(jw, roles[i], details);
        }
        jw.endArray();
    }

    private static void getMessageDigestAlgorithms(JSONWriter jw) throws JSONException {
        Provider[] providers = Security.getProviders();
        jw.array();
        for (int i = 0; providers != null && i < providers.length; ++i) {
            Iterator<Object> keys = providers[i].keySet().iterator();
            while (keys.hasNext()) {
                String key = (String)keys.next();
                if (!key.startsWith(DIGEST_KEY_PREFIX) || key.indexOf(32) != -1) continue;
                jw.value((Object)key.substring(DIGEST_KEY_PREFIX.length()));
            }
        }
        jw.endArray();
    }

    private static boolean contains(Role[] roles, Role role) {
        for (int i = 0; roles != null && role != null && i < roles.length; ++i) {
            if (!roles[i].getName().equals(role.getName())) continue;
            return true;
        }
        return false;
    }
}

