/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.webconsole.plugins.scriptconsole.internal;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineFactory;
import org.apache.commons.io.IOUtils;
import org.apache.felix.webconsole.plugins.scriptconsole.internal.Logger;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

class ScriptEngineManager
implements BundleListener,
ServiceTrackerCustomizer {
    private static final String ENGINE_FACTORY_SERVICE = "META-INF/services/" + ScriptEngineFactory.class.getName();
    private final Set<Bundle> engineSpiBundles = new HashSet<Bundle>();
    private final Map<ServiceReference, ScriptEngineFactoryState> engineSpiServices = new ConcurrentHashMap<ServiceReference, ScriptEngineFactoryState>();
    private final Logger log;
    private EngineManagerState state = new EngineManagerState();
    private ServiceTracker scriptFactoryTracker;
    private final BundleContext context;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ScriptEngineManager(BundleContext context, Logger logger) {
        this.log = logger;
        this.context = context;
        this.context.addBundleListener((BundleListener)this);
        Bundle[] bundles = this.context.getBundles();
        Set<Bundle> set = this.engineSpiBundles;
        synchronized (set) {
            for (Bundle bundle : bundles) {
                if (bundle.getState() != 32 || bundle.getEntry(ENGINE_FACTORY_SERVICE) == null) continue;
                this.engineSpiBundles.add(bundle);
            }
        }
        this.refreshScriptEngineManager();
        this.scriptFactoryTracker = new ServiceTracker(context, ScriptEngineFactory.class.getName(), (ServiceTrackerCustomizer)this);
        this.scriptFactoryTracker.open();
    }

    public List<ScriptEngineFactory> getEngineFactories() {
        return this.state.factories;
    }

    public ScriptEngine getEngineByExtension(String extension) {
        ScriptEngineFactory factory = (ScriptEngineFactory)this.state.extensionAssociations.get(extension);
        if (factory == null) {
            return null;
        }
        ScriptEngine engine = factory.getScriptEngine();
        return engine;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bundleChanged(BundleEvent event) {
        if (event.getType() == 2 && event.getBundle().getEntry(ENGINE_FACTORY_SERVICE) != null) {
            Set<Bundle> set = this.engineSpiBundles;
            synchronized (set) {
                this.engineSpiBundles.add(event.getBundle());
            }
            this.refreshScriptEngineManager();
        } else if (event.getType() == 4) {
            boolean refresh;
            Set<Bundle> set = this.engineSpiBundles;
            synchronized (set) {
                refresh = this.engineSpiBundles.remove(event.getBundle());
            }
            if (refresh) {
                this.refreshScriptEngineManager();
            }
        }
    }

    public Object addingService(ServiceReference reference) {
        ScriptEngineFactory service = (ScriptEngineFactory)this.context.getService(reference);
        this.engineSpiServices.put(reference, new ScriptEngineFactoryState(service, ScriptEngineManager.getServiceProperties(reference)));
        this.refreshScriptEngineManager();
        return service;
    }

    public void modifiedService(ServiceReference reference, Object service) {
        ScriptEngineFactoryState state = this.engineSpiServices.get(reference);
        state.properties = ScriptEngineManager.getServiceProperties(reference);
        this.refreshScriptEngineManager();
    }

    public void removedService(ServiceReference reference, Object service) {
        this.context.ungetService(reference);
        this.engineSpiServices.remove(reference);
        this.refreshScriptEngineManager();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshScriptEngineManager() {
        EngineManagerState tmp = new EngineManagerState();
        TreeSet extensions = new TreeSet();
        Object object = this.engineSpiBundles;
        synchronized (object) {
            for (Bundle bundle : this.engineSpiBundles) {
                extensions.addAll(this.registerFactories(tmp, bundle));
            }
        }
        object = this.engineSpiServices;
        synchronized (object) {
            for (ScriptEngineFactoryState state : this.engineSpiServices.values()) {
                extensions.addAll(this.registerFactory(tmp, state.scriptEngineFactory, state.properties));
            }
        }
        object = this;
        synchronized (object) {
            this.state = tmp;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection<?> registerFactories(EngineManagerState mgr, Bundle bundle) {
        URL url = bundle.getEntry(ENGINE_FACTORY_SERVICE);
        InputStream ins = null;
        TreeSet<String> extensions = new TreeSet<String>();
        try {
            ins = url.openStream();
            BufferedReader reader = new BufferedReader(new InputStreamReader(ins));
            for (String className : ScriptEngineManager.getClassNames(reader)) {
                try {
                    Class clazz = bundle.loadClass(className);
                    ScriptEngineFactory spi = (ScriptEngineFactory)clazz.newInstance();
                    this.registerFactory(mgr, spi, null);
                    extensions.addAll(spi.getExtensions());
                }
                catch (Throwable t) {
                    this.log.log(1, "Cannot register ScriptEngineFactory " + className, t);
                }
            }
        }
        catch (IOException ioe) {
        }
        finally {
            IOUtils.closeQuietly((InputStream)ins);
        }
        return extensions;
    }

    private Collection<?> registerFactory(EngineManagerState mgr, ScriptEngineFactory factory, Map<Object, Object> props) {
        this.log.log(3, String.format("Adding ScriptEngine %s, %s for language %s, %s", factory.getEngineName(), factory.getEngineVersion(), factory.getLanguageName(), factory.getLanguageVersion()));
        mgr.factories.add(factory);
        mgr.factoryProperties.put(factory, props);
        for (String ext : factory.getExtensions()) {
            mgr.extensionAssociations.put(ext, factory);
        }
        return factory.getExtensions();
    }

    public void dispose() {
        if (this.scriptFactoryTracker != null) {
            this.scriptFactoryTracker.close();
        }
    }

    static List<String> getClassNames(BufferedReader reader) throws IOException {
        String line;
        ArrayList<String> classNames = new ArrayList<String>();
        while ((line = reader.readLine()) != null) {
            if (line.startsWith("#") || line.trim().length() <= 0) continue;
            int indexOfHash = line.indexOf(35);
            if (indexOfHash >= 0) {
                line = line.substring(0, indexOfHash);
            }
            line = line.trim();
            classNames.add(line);
        }
        return classNames;
    }

    private static Map<Object, Object> getServiceProperties(ServiceReference reference) {
        HashMap<Object, Object> props = new HashMap<Object, Object>();
        for (String key : reference.getPropertyKeys()) {
            props.put(key, reference.getProperty(key));
        }
        return props;
    }

    private static class EngineManagerState {
        private final List<ScriptEngineFactory> factories = new ArrayList<ScriptEngineFactory>();
        private final Map<ScriptEngineFactory, Map<Object, Object>> factoryProperties = new HashMap<ScriptEngineFactory, Map<Object, Object>>();
        private final Map<String, ScriptEngineFactory> extensionAssociations = new HashMap<String, ScriptEngineFactory>();

        private EngineManagerState() {
        }
    }

    private static class ScriptEngineFactoryState {
        final ScriptEngineFactory scriptEngineFactory;
        Map<Object, Object> properties;

        private ScriptEngineFactoryState(ScriptEngineFactory scriptEngineFactory, Map<Object, Object> properties) {
            this.scriptEngineFactory = scriptEngineFactory;
            this.properties = properties;
        }
    }
}

