/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.threaddump.internal.jdk5;

import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.felix.threaddump.internal.ThreadDumper;
import org.apache.felix.threaddump.internal.ThreadWriter;
import org.apache.felix.threaddump.internal.jdk5.ThreadStateConverter;

public class Jdk15ThreadDumper
implements ThreadDumper {
    private static final String DEADLOCK = "Found {0} {0,choice,1#deadlock|1<deadlocks}.";

    public void printThreads(ThreadWriter threadWriter) {
        ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();
        ThreadInfo[] infos = this.getThreadInfo(threadMXBean);
        HashMap<Long, Integer> id2idx = new HashMap<Long, Integer>();
        for (int i = 0; i < infos.length; ++i) {
            id2idx.put(infos[i].getThreadId(), i);
        }
        Thread[] threads = Jdk15ThreadDumper.getThreads(id2idx);
        for (int i = 0; i < infos.length; ++i) {
            this.printThreadInfo(threadWriter, threads[i], infos[i]);
            threadWriter.printEmptyLine();
        }
        long[] deadlockedThreadsIds = this.findDeadlockedThreads(threadMXBean);
        if (deadlockedThreadsIds != null) {
            ThreadInfo info;
            ArrayList deadlocks = new ArrayList();
            for (int i = 0; i < deadlockedThreadsIds.length; ++i) {
                Long l = deadlockedThreadsIds[i];
                Integer idx = (Integer)id2idx.remove(l);
                if (idx == null) continue;
                ArrayList<Integer> idxs = new ArrayList<Integer>();
                deadlocks.add(idxs);
                do {
                    idxs.add(idx);
                } while ((idx = (info = infos[idx]) != null ? (Integer)id2idx.remove(info.getLockOwnerId()) : null) != null);
            }
            Iterator di = deadlocks.iterator();
            while (di.hasNext()) {
                List idxs = (List)di.next();
                threadWriter.printEmptyLine();
                threadWriter.println("Found one Java-level deadlock:");
                threadWriter.println("=============================");
                Iterator ii = idxs.iterator();
                while (ii.hasNext()) {
                    Integer idx = (Integer)ii.next();
                    info = infos[idx];
                    this.printDeadlockedThreadInfo(threadWriter, info);
                }
                threadWriter.printEmptyLine();
                threadWriter.println("Java stack information for the threads listed above:");
                threadWriter.println("===================================================");
                ii = idxs.iterator();
                while (ii.hasNext()) {
                    int idx = (Integer)ii.next();
                    this.printThreadInfo(threadWriter, threads[idx], infos[idx]);
                }
            }
            threadWriter.printEmptyLine();
            threadWriter.println(DEADLOCK, new Object[]{deadlocks.size()});
            threadWriter.printEmptyLine();
        }
    }

    private void printThreadInfo(ThreadWriter threadWriter, Thread t, ThreadInfo info) {
        if (t == null) {
            return;
        }
        short status = ThreadStateConverter.toStatus(t.getState());
        threadWriter.printThread(t.getName(), t.isDaemon(), t.getPriority(), t.getId(), status);
        this.printStackTrace(threadWriter, info);
    }

    protected ThreadInfo[] getThreadInfo(ThreadMXBean threadMXBean) {
        long[] threadIds = threadMXBean.getAllThreadIds();
        return threadMXBean.getThreadInfo(threadIds, Integer.MAX_VALUE);
    }

    protected long[] findDeadlockedThreads(ThreadMXBean threadMXBean) {
        return threadMXBean.findMonitorDeadlockedThreads();
    }

    protected void printStackTrace(ThreadWriter threadWriter, ThreadInfo info) {
        threadWriter.printStackTrace(info.getStackTrace());
    }

    protected void printDeadlockedThreadInfo(ThreadWriter threadWriter, ThreadInfo info) {
        threadWriter.println("\"{0}\":", new Object[]{info.getThreadName()});
        threadWriter.println("  waiting to lock monitor,");
        threadWriter.println("  which is held by \"{0}\"", new Object[]{info.getLockOwnerName()});
    }

    private static Thread[] getThreads(Map id2idx) {
        int actualThreads;
        ThreadGroup g = Thread.currentThread().getThreadGroup();
        while (g.getParent() != null) {
            g = g.getParent();
        }
        int numThreads = g.activeCount();
        Thread[] threads = new Thread[numThreads * 2];
        if (threads.length == (actualThreads = g.enumerate(threads))) {
            // empty if block
        }
        Thread[] result = new Thread[id2idx.size()];
        for (int i = 0; i < threads.length; ++i) {
            Integer idx;
            Thread t = threads[i];
            if (t == null || (idx = (Integer)id2idx.get(t.getId())) == null) continue;
            result[idx.intValue()] = t;
        }
        return result;
    }
}

