/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.ipojo.api.composite;

import java.util.ArrayList;
import java.util.List;
import org.apache.felix.ipojo.ComponentFactory;
import org.apache.felix.ipojo.ConfigurationException;
import org.apache.felix.ipojo.Factory;
import org.apache.felix.ipojo.api.ComponentType;
import org.apache.felix.ipojo.api.HandlerConfiguration;
import org.apache.felix.ipojo.api.composite.ExportedService;
import org.apache.felix.ipojo.api.composite.ImportedService;
import org.apache.felix.ipojo.api.composite.Instance;
import org.apache.felix.ipojo.api.composite.InstantiatedService;
import org.apache.felix.ipojo.api.composite.ProvidedService;
import org.apache.felix.ipojo.composite.CompositeFactory;
import org.apache.felix.ipojo.metadata.Attribute;
import org.apache.felix.ipojo.metadata.Element;
import org.osgi.framework.BundleContext;

public class CompositeComponentType
extends ComponentType {
    private BundleContext m_context;
    private ComponentFactory m_factory;
    private Element m_metadata;
    private List m_provided = new ArrayList(1);
    private List m_exported = new ArrayList(1);
    private List m_imported = new ArrayList(1);
    private List m_instantiated = new ArrayList();
    private List m_contained = new ArrayList();
    private boolean m_public = true;
    private String m_name;
    private String m_version;
    private List m_handlers = new ArrayList();

    private void ensureNotInitialized() {
        if (this.m_factory != null) {
            throw new IllegalStateException("The component type was already initialized, cannot modify metadata");
        }
    }

    private void ensureValidity() {
        if (this.m_context == null) {
            throw new IllegalStateException("The composite component type has no bundle context");
        }
    }

    public Factory getFactory() {
        this.initializeFactory();
        return this.m_factory;
    }

    public void start() {
        this.initializeFactory();
        this.m_factory.start();
    }

    public void stop() {
        this.initializeFactory();
        this.m_factory.stop();
    }

    private void initializeFactory() {
        if (this.m_factory == null) {
            this.createFactory();
        }
    }

    public CompositeComponentType setBundleContext(BundleContext bc) {
        this.ensureNotInitialized();
        this.m_context = bc;
        return this;
    }

    public CompositeComponentType setPublic(boolean visible) {
        this.ensureNotInitialized();
        this.m_public = visible;
        return this;
    }

    public CompositeComponentType setComponentTypeName(String name) {
        this.ensureNotInitialized();
        this.m_name = name;
        return this;
    }

    public CompositeComponentType setComponentTypeVersion(String version) {
        this.ensureNotInitialized();
        this.m_version = version;
        return this;
    }

    public CompositeComponentType addInstance(Instance inst) {
        this.m_contained.add(inst);
        return this;
    }

    public CompositeComponentType addSubService(ImportedService is) {
        this.m_imported.add(is);
        return this;
    }

    public CompositeComponentType addSubService(InstantiatedService is) {
        this.m_instantiated.add(is);
        return this;
    }

    public CompositeComponentType addService(ExportedService es) {
        this.m_exported.add(es);
        return this;
    }

    public CompositeComponentType addService(ProvidedService es) {
        this.m_provided.add(es);
        return this;
    }

    public CompositeComponentType addHandler(HandlerConfiguration handler) {
        this.m_handlers.add(handler);
        return this;
    }

    private Element generateComponentMetadata() {
        HandlerConfiguration inst;
        int i;
        Element element = new Element("composite", "");
        if (this.m_name != null) {
            element.addAttribute(new Attribute("name", this.m_name));
        }
        if (this.m_version != null) {
            element.addAttribute(new Attribute("version", this.m_version));
        }
        if (!this.m_public) {
            element.addAttribute(new Attribute("public", "false"));
        }
        for (i = 0; i < this.m_contained.size(); ++i) {
            inst = (Instance)this.m_contained.get(i);
            element.addElement(((Instance)inst).getElement());
        }
        for (i = 0; i < this.m_imported.size(); ++i) {
            inst = (ImportedService)this.m_imported.get(i);
            element.addElement(((ImportedService)inst).getElement());
        }
        for (i = 0; i < this.m_instantiated.size(); ++i) {
            inst = (InstantiatedService)this.m_instantiated.get(i);
            element.addElement(((InstantiatedService)inst).getElement());
        }
        for (i = 0; i < this.m_exported.size(); ++i) {
            inst = (ExportedService)this.m_exported.get(i);
            element.addElement(((ExportedService)inst).getElement());
        }
        for (i = 0; i < this.m_provided.size(); ++i) {
            inst = (ProvidedService)this.m_provided.get(i);
            element.addElement(((ProvidedService)inst).getElement());
        }
        for (i = 0; i < this.m_handlers.size(); ++i) {
            HandlerConfiguration hc = (HandlerConfiguration)this.m_handlers.get(i);
            element.addElement(hc.getElement());
        }
        return element;
    }

    private void createFactory() {
        this.ensureValidity();
        this.m_metadata = this.generateComponentMetadata();
        try {
            this.m_factory = new CompositeFactory(this.m_context, this.m_metadata);
            this.m_factory.start();
        }
        catch (ConfigurationException e) {
            throw new IllegalStateException("An exception occurs during factory initialization", e);
        }
    }
}

