/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.httplite.server;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.felix.httplite.osgi.Logger;
import org.apache.felix.httplite.osgi.ServiceRegistration;
import org.apache.felix.httplite.osgi.ServiceRegistrationHandler;
import org.apache.felix.httplite.servlet.HttpServletRequestImpl;
import org.apache.felix.httplite.servlet.HttpServletResponseImpl;

public class ServletHandler
implements ServiceRegistrationHandler {
    private final HttpServletRequestImpl m_request;
    private final HttpServletResponseImpl m_response;
    private final ServiceRegistration m_servletElement;
    private final Logger m_logger;

    public ServletHandler(HttpServletRequestImpl request, HttpServletResponseImpl response, ServiceRegistration element, Logger m_logger) {
        this.m_request = request;
        this.m_response = response;
        this.m_servletElement = element;
        this.m_logger = m_logger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handle(boolean close) throws ServletException, IOException {
        ServiceRegistration serviceRegistration = this.m_servletElement;
        synchronized (serviceRegistration) {
            if (!this.m_servletElement.hasBeenInitialized()) {
                this.m_logger.log(4, "Initializing servlet " + this.m_servletElement.getAlias());
                this.m_servletElement.getServlet().init(this.m_servletElement.getServletConfig());
                this.m_servletElement.setInitialized();
            }
        }
        if (this.m_servletElement.getContext().handleSecurity((HttpServletRequest)this.m_request, (HttpServletResponse)this.m_response)) {
            this.m_servletElement.getServlet().service((ServletRequest)this.m_request, (ServletResponse)this.m_response);
        }
        if (!this.m_response.isCommitted()) {
            this.m_response.flushBuffer();
        }
    }
}

