/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.http.proxy;

import java.util.EventListener;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.http.HttpSessionAttributeListener;
import javax.servlet.http.HttpSessionBindingEvent;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;

public class ProxyListener
implements HttpSessionAttributeListener,
HttpSessionListener,
ServletContextListener {
    private ServletContext servletContext;
    private ServiceTracker eventDispatcherTracker;
    private HttpSessionListener sessionDispatcher;
    private HttpSessionAttributeListener attributeDispatcher;

    public void contextInitialized(ServletContextEvent sce) {
        this.servletContext = sce.getServletContext();
    }

    public void contextDestroyed(ServletContextEvent sce) {
        if (this.eventDispatcherTracker != null) {
            this.eventDispatcherTracker.close();
            this.eventDispatcherTracker = null;
        }
        this.servletContext = null;
    }

    public void sessionCreated(HttpSessionEvent se) {
        HttpSessionListener sessionDispatcher = this.getSessionDispatcher();
        if (sessionDispatcher != null) {
            sessionDispatcher.sessionCreated(se);
        }
    }

    public void sessionDestroyed(HttpSessionEvent se) {
        HttpSessionListener sessionDispatcher = this.getSessionDispatcher();
        if (sessionDispatcher != null) {
            sessionDispatcher.sessionDestroyed(se);
        }
    }

    public void attributeAdded(HttpSessionBindingEvent se) {
        HttpSessionAttributeListener attributeDispatcher = this.getAttributeDispatcher();
        if (attributeDispatcher != null) {
            attributeDispatcher.attributeAdded(se);
        }
    }

    public void attributeRemoved(HttpSessionBindingEvent se) {
        HttpSessionAttributeListener attributeDispatcher = this.getAttributeDispatcher();
        if (attributeDispatcher != null) {
            attributeDispatcher.attributeRemoved(se);
        }
    }

    public void attributeReplaced(HttpSessionBindingEvent se) {
        HttpSessionAttributeListener attributeDispatcher = this.getAttributeDispatcher();
        if (attributeDispatcher != null) {
            attributeDispatcher.attributeReplaced(se);
        }
    }

    private Object getDispatcher() {
        if (this.eventDispatcherTracker == null) {
            Object bundleContextAttr = this.servletContext.getAttribute(BundleContext.class.getName());
            if (!(bundleContextAttr instanceof BundleContext)) {
                return null;
            }
            try {
                BundleContext bundleContext = (BundleContext)bundleContextAttr;
                Filter filter = ProxyListener.createFilter(bundleContext, null);
                this.eventDispatcherTracker = new ServiceTracker(bundleContext, filter, null){

                    public void removedService(ServiceReference reference, Object service) {
                        ProxyListener.this.sessionDispatcher = null;
                        ProxyListener.this.attributeDispatcher = null;
                        super.removedService(reference, service);
                    }
                };
                this.eventDispatcherTracker.open();
            }
            catch (InvalidSyntaxException invalidSyntaxException) {
                // empty catch block
            }
        }
        return this.eventDispatcherTracker.getService();
    }

    private HttpSessionListener getSessionDispatcher() {
        Object dispatcher;
        if (this.sessionDispatcher == null && (dispatcher = this.getDispatcher()) instanceof HttpSessionListener) {
            this.sessionDispatcher = (HttpSessionListener)dispatcher;
        }
        return this.sessionDispatcher;
    }

    private HttpSessionAttributeListener getAttributeDispatcher() {
        Object dispatcher;
        if (this.attributeDispatcher == null && (dispatcher = this.getDispatcher()) instanceof HttpSessionAttributeListener) {
            this.attributeDispatcher = (HttpSessionAttributeListener)dispatcher;
        }
        return this.attributeDispatcher;
    }

    private static Filter createFilter(BundleContext context, String filter) throws InvalidSyntaxException {
        StringBuffer str = new StringBuffer();
        str.append("(&(").append("objectClass").append("=");
        str.append(EventListener.class.getName()).append(")");
        str.append(filter != null ? filter : "(http.felix.dispatcher=*)").append(")");
        return context.createFilter(str.toString());
    }
}

