/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.http.base.internal.handler;

import java.util.Arrays;
import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.servlet.Filter;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import org.apache.felix.http.base.internal.handler.AbstractHandler;
import org.apache.felix.http.base.internal.handler.FilterHandler;
import org.apache.felix.http.base.internal.handler.ServletHandler;
import org.osgi.service.http.NamespaceException;

public final class HandlerRegistry {
    private final ConcurrentMap<Servlet, ServletHandler> servletMap = new ConcurrentHashMap<Servlet, ServletHandler>();
    private final ConcurrentMap<Filter, FilterHandler> filterMap = new ConcurrentHashMap<Filter, FilterHandler>();
    private final ConcurrentMap<String, Servlet> aliasMap = new ConcurrentHashMap<String, Servlet>();
    private volatile ServletHandler[] servlets = new ServletHandler[0];
    private volatile FilterHandler[] filters = new FilterHandler[0];

    public ServletHandler[] getServlets() {
        return this.servlets;
    }

    public FilterHandler[] getFilters() {
        return this.filters;
    }

    public void addServlet(ServletHandler handler) throws ServletException, NamespaceException {
        handler.init();
        if (this.servletMap.putIfAbsent(handler.getServlet(), handler) != null) {
            throw new ServletException("Servlet instance already registered");
        }
        if (this.aliasMap.putIfAbsent(handler.getAlias(), handler.getServlet()) != null) {
            this.servletMap.remove(handler.getServlet(), handler);
            handler.destroy();
            throw new NamespaceException("Servlet with alias '" + handler.getAlias() + "' already registered");
        }
        this.updateServletArray();
    }

    public void addFilter(FilterHandler handler) throws ServletException {
        handler.init();
        if (this.filterMap.putIfAbsent(handler.getFilter(), handler) != null) {
            throw new ServletException("Filter instance already registered");
        }
        this.updateFilterArray();
    }

    public void removeServlet(Servlet servlet, boolean destroy) {
        ServletHandler handler = (ServletHandler)this.servletMap.remove(servlet);
        if (handler != null) {
            this.updateServletArray();
            this.aliasMap.remove(handler.getAlias());
            if (destroy) {
                handler.destroy();
            }
        }
    }

    public void removeFilter(Filter filter, boolean destroy) {
        FilterHandler handler = (FilterHandler)this.filterMap.remove(filter);
        if (handler != null) {
            this.updateFilterArray();
            if (destroy) {
                handler.destroy();
            }
        }
    }

    public Servlet getServletByAlias(String alias) {
        return (Servlet)this.aliasMap.get(alias);
    }

    public void removeAll() {
        AbstractHandler handler;
        Iterator it = this.servletMap.values().iterator();
        while (it.hasNext()) {
            handler = (ServletHandler)it.next();
            it.remove();
            this.aliasMap.remove(((ServletHandler)handler).getAlias());
            ((ServletHandler)handler).destroy();
        }
        it = this.filterMap.values().iterator();
        while (it.hasNext()) {
            handler = (FilterHandler)it.next();
            it.remove();
            ((FilterHandler)handler).destroy();
        }
        this.updateServletArray();
        this.updateFilterArray();
    }

    private void updateServletArray() {
        Object[] tmp = this.servletMap.values().toArray(new ServletHandler[this.servletMap.size()]);
        Arrays.sort(tmp);
        this.servlets = tmp;
    }

    private void updateFilterArray() {
        Object[] tmp = this.filterMap.values().toArray(new FilterHandler[this.filterMap.size()]);
        Arrays.sort(tmp);
        this.filters = tmp;
    }
}

