/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.atomos.utils.substrate.impl;

import aQute.bnd.annotation.spi.ServiceProvider;
import java.nio.file.Path;
import java.util.Optional;
import org.apache.felix.atomos.utils.substrate.api.NativeImageCli;
import org.apache.felix.atomos.utils.substrate.api.NativeImageCliBuilder;
import org.apache.felix.atomos.utils.substrate.impl.NativeImageCliImpl;
import org.apache.felix.atomos.utils.substrate.impl.NativeImageCliUtil;

@ServiceProvider(value=NativeImageCliBuilder.class)
public class NativeImageCliBuilderImpl
implements NativeImageCliBuilder {
    public Optional<NativeImageCli> findNativeImageExecutable() {
        return this.findNativeImageExecutable(null);
    }

    public Optional<NativeImageCli> findNativeImageExecutable(Path exec) {
        Optional<Path> oExecPath = NativeImageCliUtil.findNativeImageExecutable(exec);
        if (oExecPath.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(new NativeImageCliImpl(oExecPath.get()));
    }

    public Optional<NativeImageCli> fromExecutable(Path exec) {
        String version = NativeImageCliUtil.getVersion(exec);
        if (version == null) {
            return Optional.empty();
        }
        return Optional.of(new NativeImageCliImpl(exec));
    }
}

