/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.atomos.impl.content;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import org.osgi.framework.connect.ConnectContent;

public class ConnectContentIndexed
implements ConnectContent {
    private final String index;
    private final Set<String> entries;
    final Supplier<Optional<Map<String, String>>> headers;

    public ConnectContentIndexed(String index, List<String> entries, Supplier<Optional<Map<String, String>>> headers) {
        this.index = index;
        this.entries = Collections.unmodifiableSet(new LinkedHashSet<String>(entries));
        this.headers = headers;
    }

    public Optional<Map<String, String>> getHeaders() {
        return this.headers.get();
    }

    public Iterable<String> getEntries() throws IOException {
        return this.entries;
    }

    public Optional<ConnectContent.ConnectEntry> getEntry(String name) {
        if (this.entries.contains(name)) {
            String slashName = '/' + name;
            URL resource = this.getClass().getResource(this.index + slashName);
            if (resource == null) {
                resource = this.getClass().getResource(slashName);
            }
            if (resource != null) {
                return Optional.of(new URLConnectEntry(name, resource));
            }
        }
        return Optional.empty();
    }

    public Optional<ClassLoader> getClassLoader() {
        return Optional.of(this.getClass().getClassLoader());
    }

    public void open() throws IOException {
    }

    public void close() throws IOException {
    }

    static class URLConnectEntry
    implements ConnectContent.ConnectEntry {
        private final String name;
        private final URL resource;

        URLConnectEntry(String name, URL resource) {
            this.name = name;
            this.resource = resource;
        }

        public String getName() {
            return this.name;
        }

        public long getContentLength() {
            try {
                return this.resource.openConnection().getContentLengthLong();
            }
            catch (IOException e) {
                return -1L;
            }
        }

        public long getLastModified() {
            try {
                return this.resource.openConnection().getDate();
            }
            catch (IOException e) {
                return 0L;
            }
        }

        public InputStream getInputStream() throws IOException {
            return this.resource.openStream();
        }
    }
}

