/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.atomos.impl.content;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.zip.ZipFile;
import org.apache.felix.atomos.impl.base.AtomosBase;
import org.apache.felix.atomos.impl.content.ConnectContentJar;

public class ConnectContentCloseableJar
extends ConnectContentJar {
    public ConnectContentCloseableJar(String fileName, Supplier<File> rootSupplier, Supplier<Optional<Map<String, String>>> headers) {
        super(new ZipFileHolder(fileName, rootSupplier), (Supplier<ZipFile> z) -> ((ZipFileHolder)z).accept((Supplier<ZipFile>)z), headers);
    }

    static class ZipFileHolder
    implements Supplier<ZipFile>,
    Consumer<Supplier<ZipFile>> {
        private final Supplier<File> rootSupplier;
        private final String fileName;
        private volatile ZipFile zipFile;

        public ZipFileHolder(String fileName, Supplier<File> rootSupplier) {
            this.fileName = fileName;
            this.rootSupplier = rootSupplier;
        }

        @Override
        public void accept(Supplier<ZipFile> s) {
            if (s != this) {
                return;
            }
            ZipFile current = this.zipFile;
            if (current != null) {
                this.zipFile = null;
                try {
                    current.close();
                }
                catch (IOException e) {
                    AtomosBase.sneakyThrow(e);
                }
            }
        }

        @Override
        public ZipFile get() {
            ZipFile current = this.zipFile;
            if (current == null) {
                try {
                    current = this.zipFile = new ZipFile(new File(this.rootSupplier.get(), this.fileName));
                }
                catch (IOException e) {
                    AtomosBase.sneakyThrow(e);
                }
            }
            return current;
        }
    }
}

