// Licensed to the Apache Software Foundation (ASF) under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  The ASF licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//
//   http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing,
// software distributed under the License is distributed on an
// "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied.  See the License for the
// specific language governing permissions and limitations
// under the License.

package org.apache.doris.nereids.metrics.event;

import org.apache.doris.nereids.memo.Group;
import org.apache.doris.nereids.memo.GroupExpression;
import org.apache.doris.nereids.metrics.Event;
import org.apache.doris.nereids.util.Utils;

import java.util.List;

/**
 * group merge event
 */
public class GroupMergeEvent extends Event {
    private final Group source;
    private final Group destination;
    private final List<GroupExpression> needReplaceGroupExpressions;

    private GroupMergeEvent(Group source, Group destination, List<GroupExpression> needReplaceGroupExpressions) {
        this.source = source;
        this.destination = destination;
        this.needReplaceGroupExpressions = needReplaceGroupExpressions;
    }

    public static GroupMergeEvent of(Group source, Group destination,
            List<GroupExpression> needReplaceGroupExpressions) {
        return checkConnectContext(GroupMergeEvent.class)
                ? new GroupMergeEvent(source, destination, needReplaceGroupExpressions) : null;
    }

    @Override
    public String toString() {
        return Utils.toSqlString("GroupMergeEvent", "source", source,
                "destination", destination,
                "needReplaceGroupExpressions", needReplaceGroupExpressions);
    }
}
