// Licensed to the Apache Software Foundation (ASF) under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  The ASF licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//
//   http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing,
// software distributed under the License is distributed on an
// "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied.  See the License for the
// specific language governing permissions and limitations
// under the License.

package org.apache.doris.job.common;

import org.apache.doris.common.InternalErrorCode;
import org.apache.doris.common.io.Text;
import org.apache.doris.common.io.Writable;
import org.apache.doris.persist.gson.GsonUtils;

import com.google.gson.annotations.SerializedName;
import org.apache.commons.lang3.StringUtils;

import java.io.DataOutput;
import java.io.IOException;

public class FailureReason implements Writable {
    @SerializedName(value = "code")
    private InternalErrorCode code;
    @SerializedName(value = "msg")
    private String msg;

    public FailureReason(InternalErrorCode errCode, String msg) {
        this.code = errCode;
        this.msg = msg;
    }

    public FailureReason(String msg) {
        this.msg = msg;
        if (StringUtils.isNotEmpty(msg) && msg.contains("Insert has filtered data in strict mode")) {
            this.code = InternalErrorCode.TOO_MANY_FAILURE_ROWS_ERR;
        } else {
            this.code = InternalErrorCode.INTERNAL_ERR;
        }
    }

    public InternalErrorCode getCode() {
        return code;
    }

    public void setCode(InternalErrorCode code) {
        this.code = code;
    }

    public String getMsg() {
        return msg;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }

    @Override
    public void write(DataOutput out) throws IOException {
        String json = GsonUtils.GSON.toJson(this);
        Text.writeString(out, json);
    }

    @Override
    public String toString() {
        return "ErrorReason{" + "code=" + code + ", msg='" + msg + '\'' + '}';
    }
}
