/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.extended.kubectl;

import io.kubernetes.client.Discovery;
import io.kubernetes.client.apimachinery.GroupVersionResource;
import io.kubernetes.client.common.KubernetesListObject;
import io.kubernetes.client.common.KubernetesObject;
import io.kubernetes.client.extended.kubectl.KubectlAnnotate;
import io.kubernetes.client.extended.kubectl.KubectlApiResources;
import io.kubernetes.client.extended.kubectl.KubectlApply;
import io.kubernetes.client.extended.kubectl.KubectlCopy;
import io.kubernetes.client.extended.kubectl.KubectlCordon;
import io.kubernetes.client.extended.kubectl.KubectlCreate;
import io.kubernetes.client.extended.kubectl.KubectlDelete;
import io.kubernetes.client.extended.kubectl.KubectlDrain;
import io.kubernetes.client.extended.kubectl.KubectlExec;
import io.kubernetes.client.extended.kubectl.KubectlGet;
import io.kubernetes.client.extended.kubectl.KubectlLabel;
import io.kubernetes.client.extended.kubectl.KubectlLog;
import io.kubernetes.client.extended.kubectl.KubectlPatch;
import io.kubernetes.client.extended.kubectl.KubectlPortForward;
import io.kubernetes.client.extended.kubectl.KubectlReplace;
import io.kubernetes.client.extended.kubectl.KubectlScale;
import io.kubernetes.client.extended.kubectl.KubectlTaint;
import io.kubernetes.client.extended.kubectl.KubectlTop;
import io.kubernetes.client.extended.kubectl.KubectlVersion;
import io.kubernetes.client.extended.kubectl.exception.KubectlException;
import io.kubernetes.client.openapi.ApiClient;
import io.kubernetes.client.openapi.ApiException;
import io.kubernetes.client.openapi.Configuration;
import io.kubernetes.client.util.ModelMapper;
import io.kubernetes.client.util.generic.GenericKubernetesApi;

public class Kubectl {
    public static <ApiType extends KubernetesObject> KubectlGet<ApiType> get(Class<ApiType> apiTypeClass) {
        return new KubectlGet<ApiType>(apiTypeClass);
    }

    public static <ApiType extends KubernetesObject> KubectlCreate<ApiType> create(Class<ApiType> clazz) {
        return new KubectlCreate<ApiType>(clazz);
    }

    public static <ApiType extends KubernetesObject> KubectlDelete<ApiType> delete(Class<ApiType> clazz) {
        return new KubectlDelete<ApiType>(clazz);
    }

    public static <ApiType extends KubernetesObject> KubectlReplace<ApiType> replace(Class<ApiType> clazz) {
        return new KubectlReplace<ApiType>(clazz);
    }

    public static <ApiType extends KubernetesObject> KubectlApply<ApiType> apply(Class<ApiType> clazz) {
        return new KubectlApply<ApiType>(clazz);
    }

    public static KubectlDrain drain() {
        return new KubectlDrain();
    }

    public static KubectlCordon cordon() {
        return new KubectlCordon(true);
    }

    public static KubectlCordon uncordon() {
        return new KubectlCordon(false);
    }

    public static <ApiType extends KubernetesObject, MetricsType> KubectlTop<ApiType, MetricsType> top(Class<ApiType> apiTypeClass, Class<MetricsType> metricsTypeClass) {
        return new KubectlTop(apiTypeClass);
    }

    public static KubectlTaint taint() {
        return new KubectlTaint();
    }

    public static KubectlCopy copy() {
        return new KubectlCopy();
    }

    public static <ApiType extends KubernetesObject> KubectlLabel<ApiType> label(Class<ApiType> apiTypeClass) {
        return new KubectlLabel<ApiType>(apiTypeClass);
    }

    public static <ApiType extends KubernetesObject> KubectlAnnotate<ApiType> annotate(Class<ApiType> apiTypeClass) {
        return new KubectlAnnotate<ApiType>(apiTypeClass);
    }

    public static KubectlVersion version() {
        return new KubectlVersion();
    }

    public static <ApiType extends KubernetesObject> KubectlScale<ApiType> scale(Class<ApiType> apiTypeClass) {
        return new KubectlScale<ApiType>(apiTypeClass);
    }

    public static KubectlExec exec() {
        return new KubectlExec();
    }

    public static KubectlLog log() {
        return new KubectlLog();
    }

    public static KubectlPortForward portforward() {
        return new KubectlPortForward();
    }

    public static KubectlApiResources apiResources() {
        return new KubectlApiResources();
    }

    public static <ApiType extends KubernetesObject> KubectlPatch<ApiType> patch(Class<ApiType> apiTypeClass) {
        return new KubectlPatch<ApiType>(apiTypeClass);
    }

    static abstract class ResourceAndContainerBuilder<ApiType extends KubernetesObject, T extends ResourceAndContainerBuilder<ApiType, T>>
    extends ResourceBuilder<ApiType, T> {
        String container;

        ResourceAndContainerBuilder(Class<ApiType> apiTypeClass) {
            super(apiTypeClass);
        }

        public T container(String container) {
            this.container = container;
            return (T)this;
        }
    }

    static abstract class ResourceBuilder<ApiType extends KubernetesObject, T extends ResourceBuilder<ApiType, T>>
    extends NamespacedApiClientBuilder<T> {
        final Class<ApiType> apiTypeClass;
        String name;

        ResourceBuilder(Class<ApiType> apiTypeClass) {
            this.apiTypeClass = apiTypeClass;
        }

        public T name(String name) {
            this.name = name;
            return (T)this;
        }

        protected GenericKubernetesApi<ApiType, KubernetesListObject> getGenericApi() throws KubectlException {
            return this.getGenericApi(this.apiTypeClass, KubernetesListObject.class);
        }
    }

    static abstract class ApiClientBuilder<T extends ApiClientBuilder> {
        ApiClient apiClient = Configuration.getDefaultApiClient();
        boolean skipDiscovery = false;

        ApiClientBuilder() {
        }

        protected void refreshDiscovery() throws KubectlException {
            if (this.skipDiscovery) {
                return;
            }
            try {
                ModelMapper.refresh((Discovery)new Discovery(this.apiClient));
            }
            catch (ApiException e) {
                throw new KubectlException(e);
            }
        }

        protected <ApiType extends KubernetesObject> GenericKubernetesApi<ApiType, ? extends KubernetesListObject> getGenericApi(Class<ApiType> apiTypeClass) throws KubectlException {
            String apiListTypeClassName = apiTypeClass.getName() + "List";
            try {
                Class<?> apiTypeListClass = apiTypeClass.getClassLoader().loadClass(apiListTypeClassName);
                return this.getGenericApi(apiTypeClass, apiTypeListClass);
            }
            catch (ClassNotFoundException e) {
                throw new KubectlException("No such api list type class " + apiListTypeClassName + ", consider explicitly load the class by apiListTypeClass()?");
            }
        }

        protected <ApiType extends KubernetesObject, ApiListType extends KubernetesListObject> GenericKubernetesApi<ApiType, ApiListType> getGenericApi(Class<ApiType> apiTypeClass, Class<ApiListType> apiListTypeClass) throws KubectlException {
            GroupVersionResource groupVersionResource = ModelMapper.getGroupVersionResourceByClass(apiTypeClass);
            if (groupVersionResource == null) {
                throw new KubectlException("Unexpected unknown resource type: " + apiTypeClass);
            }
            GenericKubernetesApi api = new GenericKubernetesApi(apiTypeClass, apiListTypeClass, groupVersionResource.getGroup(), groupVersionResource.getVersion(), groupVersionResource.getResource(), this.apiClient);
            return api;
        }

        public T apiClient(ApiClient apiClient) {
            this.apiClient = apiClient;
            return (T)this;
        }

        public T skipDiscovery() {
            this.skipDiscovery = true;
            return (T)this;
        }
    }

    static abstract class NamespacedApiClientBuilder<T extends NamespacedApiClientBuilder>
    extends ApiClientBuilder<T> {
        String namespace;

        NamespacedApiClientBuilder() {
        }

        public T namespace(String namespace) {
            this.namespace = namespace;
            return (T)this;
        }
    }

    public static interface Executable<OUTPUT> {
        public OUTPUT execute() throws KubectlException;
    }
}

