/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.containerregistry.implementation;

import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.resourcemanager.containerregistry.ContainerRegistryManager;
import com.azure.resourcemanager.containerregistry.implementation.RegistriesWebhooksClientImpl;
import com.azure.resourcemanager.containerregistry.implementation.RegistryImpl;
import com.azure.resourcemanager.containerregistry.models.Webhook;
import com.azure.resourcemanager.containerregistry.models.WebhookOperations;
import reactor.core.publisher.Mono;

public class WebhookOperationsImpl
implements WebhookOperations {
    private final RegistryImpl containerRegistry;
    private final RegistriesWebhooksClientImpl webhooksClient;

    WebhookOperationsImpl(RegistryImpl containerRegistry) {
        this.containerRegistry = containerRegistry;
        this.webhooksClient = containerRegistry != null ? new RegistriesWebhooksClientImpl((ContainerRegistryManager)containerRegistry.manager(), containerRegistry) : null;
    }

    @Override
    public Webhook get(String webhookName) {
        return (Webhook)this.getAsync(webhookName).block();
    }

    @Override
    public Mono<Webhook> getAsync(String webhookName) {
        if (this.containerRegistry == null) {
            return null;
        }
        return this.webhooksClient.getAsync(this.containerRegistry.resourceGroupName(), this.containerRegistry.name(), webhookName);
    }

    @Override
    public void delete(String webhookName) {
        if (this.containerRegistry == null) {
            return;
        }
        this.webhooksClient.delete(this.containerRegistry.resourceGroupName(), this.containerRegistry.name(), webhookName);
    }

    @Override
    public Mono<Void> deleteAsync(String webhookName) {
        if (this.containerRegistry == null) {
            return null;
        }
        return this.webhooksClient.deleteAsync(this.containerRegistry.resourceGroupName(), this.containerRegistry.name(), webhookName);
    }

    @Override
    public PagedIterable<Webhook> list() {
        if (this.containerRegistry == null) {
            return null;
        }
        return this.webhooksClient.list(this.containerRegistry.resourceGroupName(), this.containerRegistry.name());
    }

    @Override
    public PagedFlux<Webhook> listAsync() {
        if (this.containerRegistry == null) {
            return null;
        }
        return this.webhooksClient.listAsync(this.containerRegistry.resourceGroupName(), this.containerRegistry.name());
    }
}

