/*
 * Decompiled with CFR 0.152.
 */
package com.qcloud.cos.internal.crypto;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.qcloud.cos.exception.CosClientException;
import com.qcloud.cos.internal.CosServiceRequest;
import com.qcloud.cos.internal.crypto.COSCryptoScheme;
import com.qcloud.cos.internal.crypto.COSKeyWrapScheme;
import com.qcloud.cos.internal.crypto.CipherLite;
import com.qcloud.cos.internal.crypto.ContentCryptoScheme;
import com.qcloud.cos.internal.crypto.CryptoMode;
import com.qcloud.cos.internal.crypto.EncryptionMaterials;
import com.qcloud.cos.internal.crypto.EncryptionMaterialsAccessor;
import com.qcloud.cos.internal.crypto.KMSEncryptionMaterials;
import com.qcloud.cos.internal.crypto.KMSEncryptionMaterialsProvider;
import com.qcloud.cos.internal.crypto.KMSSecuredCEK;
import com.qcloud.cos.internal.crypto.QCLOUDKMS;
import com.qcloud.cos.internal.crypto.SecuredCEK;
import com.qcloud.cos.model.MaterialsDescriptionProvider;
import com.qcloud.cos.model.ObjectMetadata;
import com.qcloud.cos.utils.Base64;
import com.qcloud.cos.utils.Jackson;
import com.tencentcloudapi.kms.v20190118.models.DecryptRequest;
import com.tencentcloudapi.kms.v20190118.models.DecryptResponse;
import com.tencentcloudapi.kms.v20190118.models.EncryptRequest;
import com.tencentcloudapi.kms.v20190118.models.EncryptResponse;
import java.nio.charset.Charset;
import java.security.Key;
import java.security.Provider;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class ContentCryptoMaterial {
    private final String keyWrappingAlgorithm;
    private final CipherLite cipherLite;
    private final Map<String, String> kekMaterialsDescription;
    private final byte[] encryptedCEK;
    private final byte[] securedIV;
    private static final Logger log = LoggerFactory.getLogger(ContentCryptoMaterial.class);

    ContentCryptoMaterial(Map<String, String> kekMaterialsDescription, byte[] encryptedCEK, String keyWrappingAlgorithm, CipherLite cipherLite, byte[] securedIV) {
        this.cipherLite = cipherLite;
        this.keyWrappingAlgorithm = keyWrappingAlgorithm;
        this.encryptedCEK = (byte[])encryptedCEK.clone();
        this.kekMaterialsDescription = kekMaterialsDescription;
        this.securedIV = securedIV;
    }

    String getKeyWrappingAlgorithm() {
        return this.keyWrappingAlgorithm;
    }

    private boolean usesKMSKey() {
        return KMSSecuredCEK.isKMSKeyWrapped(this.keyWrappingAlgorithm);
    }

    ContentCryptoScheme getContentCryptoScheme() {
        return this.cipherLite.getContentCryptoScheme();
    }

    ObjectMetadata toObjectMetadata(ObjectMetadata metadata, CryptoMode mode) {
        return this.toObjectMetadata(metadata);
    }

    private ObjectMetadata toObjectMetadata(ObjectMetadata metadata) {
        String keyWrapAlgo;
        byte[] encryptedCEK = this.getEncryptedCEK();
        metadata.addUserMetadata("client-side-encryption-key", Base64.encodeAsString(encryptedCEK));
        metadata.addUserMetadata("client-side-encryption-start", Base64.encodeAsString(this.securedIV));
        String matdesc = this.kekMaterialDescAsJson();
        if (matdesc != null) {
            metadata.addUserMetadata("client-side-encryption-matdesc", this.kekMaterialDescAsJson());
        }
        ContentCryptoScheme scheme = this.getContentCryptoScheme();
        metadata.addUserMetadata("client-side-encryption-cek-alg", scheme.getCipherAlgorithm());
        int tagLen = scheme.getTagLengthInBits();
        if (tagLen > 0) {
            metadata.addUserMetadata("x-cos-tag-len", String.valueOf(tagLen));
        }
        if ((keyWrapAlgo = this.getKeyWrappingAlgorithm()) != null) {
            metadata.addUserMetadata("client-side-encryption-wrap-alg", keyWrapAlgo);
        }
        return metadata;
    }

    String toJsonString() {
        String keyWrapAlgo;
        HashMap<String, String> map = new HashMap<String, String>();
        byte[] encryptedCEK = this.getEncryptedCEK();
        map.put("x-cos-key-v2", Base64.encodeAsString(encryptedCEK));
        byte[] iv = this.cipherLite.getIV();
        map.put("x-cos-iv", Base64.encodeAsString(iv));
        map.put("x-cos-matdesc", this.kekMaterialDescAsJson());
        ContentCryptoScheme scheme = this.getContentCryptoScheme();
        map.put("x-cos-cek-alg", scheme.getCipherAlgorithm());
        int tagLen = scheme.getTagLengthInBits();
        if (tagLen > 0) {
            map.put("x-cos-tag-len", String.valueOf(tagLen));
        }
        if ((keyWrapAlgo = this.getKeyWrappingAlgorithm()) != null) {
            map.put("x-cos-wrap-alg", keyWrapAlgo);
        }
        return Jackson.toJsonString(map);
    }

    private String kekMaterialDescAsJson() {
        Map<String, String> kekMaterialDesc = this.getKEKMaterialsDescription();
        if (kekMaterialDesc == null || kekMaterialDesc.isEmpty()) {
            return null;
        }
        return Jackson.toJsonString(kekMaterialDesc);
    }

    private static Map<String, String> matdescFromJson(String json) {
        Map map = Jackson.fromJsonString(json, Map.class);
        return map == null ? null : Collections.unmodifiableMap(map);
    }

    private static SecretKey cek(byte[] cekSecured, String keyWrapAlgo, EncryptionMaterials materials, Provider securityProvider, ContentCryptoScheme contentCryptoScheme, QCLOUDKMS kms) {
        Key kek;
        if (KMSSecuredCEK.isKMSKeyWrapped(keyWrapAlgo)) {
            return ContentCryptoMaterial.cekByKMS(cekSecured, keyWrapAlgo, materials, contentCryptoScheme, kms);
        }
        if (materials.getKeyPair() != null ? (kek = materials.getKeyPair().getPrivate()) == null : (kek = materials.getSymmetricKey()) == null) {
            throw new CosClientException("Key encrypting key not available");
        }
        try {
            if (keyWrapAlgo != null) {
                Cipher cipher = securityProvider == null ? Cipher.getInstance(keyWrapAlgo) : Cipher.getInstance(keyWrapAlgo, securityProvider);
                cipher.init(4, kek);
                return (SecretKey)cipher.unwrap(cekSecured, keyWrapAlgo, 3);
            }
            Cipher cipher = securityProvider != null ? Cipher.getInstance(kek.getAlgorithm(), securityProvider) : Cipher.getInstance(kek.getAlgorithm());
            cipher.init(2, kek);
            byte[] decryptedSymmetricKeyBytes = cipher.doFinal(cekSecured);
            return new SecretKeySpec(decryptedSymmetricKeyBytes, "AES");
        }
        catch (Exception e) {
            throw new CosClientException("Unable to decrypt symmetric key from object metadata", e);
        }
    }

    private static SecretKey cekByKMS(byte[] cekSecured, String keyWrapAlgo, EncryptionMaterials materials, ContentCryptoScheme contentCryptoScheme, QCLOUDKMS kms) {
        DecryptRequest decryptReq = new DecryptRequest();
        Map<String, String> materialDesc = materials.getMaterialsDescription();
        try {
            ObjectMapper mapper = new ObjectMapper();
            decryptReq.setEncryptionContext(mapper.writeValueAsString(materialDesc));
        }
        catch (JsonProcessingException e) {
            throw new CosClientException("decrypt request set encryption context got json processing exception", e);
        }
        decryptReq.setCiphertextBlob(new String(cekSecured));
        DecryptResponse decryptRes = kms.decrypt(decryptReq);
        byte[] key = Base64.decode(decryptRes.getPlaintext());
        return new SecretKeySpec(key, contentCryptoScheme.getKeyGeneratorAlgorithm());
    }

    static ContentCryptoMaterial fromObjectMetadata(ObjectMetadata metadata, EncryptionMaterialsAccessor kekMaterialAccessor, Provider securityProvider, boolean keyWrapExpected, QCLOUDKMS kms) {
        return ContentCryptoMaterial.fromObjectMetadata0(metadata, kekMaterialAccessor, securityProvider, null, keyWrapExpected, kms);
    }

    static ContentCryptoMaterial fromObjectMetadata(ObjectMetadata metadata, EncryptionMaterialsAccessor kekMaterialAccessor, Provider securityProvider, long[] range, boolean keyWrapExpected, QCLOUDKMS kms) {
        return ContentCryptoMaterial.fromObjectMetadata0(metadata, kekMaterialAccessor, securityProvider, range, keyWrapExpected, kms);
    }

    private static ContentCryptoMaterial fromObjectMetadata0(ObjectMetadata metadata, EncryptionMaterialsAccessor kekMaterialAccessor, Provider securityProvider, long[] range, boolean keyWrapExpected, QCLOUDKMS kms) {
        EncryptionMaterials materials;
        Map<String, String> userMeta = metadata.getUserMetadata();
        if (userMeta.get("client-side-encryption-key") != null) {
            return ContentCryptoMaterial.fromObjectMetadata1(userMeta, kekMaterialAccessor, securityProvider, range, keyWrapExpected, kms);
        }
        String b64key = userMeta.get("x-cos-key-v2");
        if (b64key == null && (b64key = userMeta.get("x-cos-key")) == null) {
            throw new CosClientException("Content encrypting key not found.");
        }
        byte[] cekWrapped = Base64.decode(b64key);
        byte[] iv = Base64.decode(userMeta.get("x-cos-iv"));
        if (cekWrapped == null || iv == null) {
            throw new CosClientException("Content encrypting key or IV not found.");
        }
        String matdescStr = userMeta.get("x-cos-matdesc");
        String keyWrapAlgo = userMeta.get("x-cos-wrap-alg");
        boolean isKMS = KMSSecuredCEK.isKMSKeyWrapped(keyWrapAlgo);
        Map<String, String> core = ContentCryptoMaterial.matdescFromJson(matdescStr);
        if (isKMS) {
            materials = new KMSEncryptionMaterials(core.get("kms_cmk_id"));
            materials.addDescriptions(core);
        } else {
            EncryptionMaterials encryptionMaterials = materials = kekMaterialAccessor == null ? null : kekMaterialAccessor.getEncryptionMaterials(core);
            if (materials == null) {
                throw new CosClientException("Unable to retrieve the client encryption materials");
            }
        }
        String cekAlgo = userMeta.get("x-cos-cek-alg");
        boolean isRangeGet = range != null;
        ContentCryptoScheme contentCryptoScheme = ContentCryptoScheme.fromCEKAlgo(cekAlgo, isRangeGet);
        if (isRangeGet) {
            iv = contentCryptoScheme.adjustIV(iv, range[0]);
        } else {
            String s;
            int tagLenActual;
            int tagLenExpected = contentCryptoScheme.getTagLengthInBits();
            if (tagLenExpected > 0 && tagLenExpected != (tagLenActual = Integer.parseInt(s = userMeta.get("x-cos-tag-len")))) {
                throw new CosClientException("Unsupported tag length: " + tagLenActual + ", expected: " + tagLenExpected);
            }
        }
        if (keyWrapExpected && keyWrapAlgo == null) {
            throw ContentCryptoMaterial.newKeyWrapException();
        }
        SecretKey cek = ContentCryptoMaterial.cek(cekWrapped, keyWrapAlgo, materials, securityProvider, contentCryptoScheme, kms);
        return new ContentCryptoMaterial(core, cekWrapped, keyWrapAlgo, contentCryptoScheme.createCipherLite(cek, iv, 2, securityProvider), null);
    }

    private static ContentCryptoMaterial fromObjectMetadata1(Map<String, String> userMeta, EncryptionMaterialsAccessor kekMaterialAccessor, Provider securityProvider, long[] range, boolean keyWrapExpected, QCLOUDKMS kms) {
        EncryptionMaterials materials;
        String b64SecuredKey = userMeta.get("client-side-encryption-key");
        if (b64SecuredKey == null) {
            throw new CosClientException("Content encrypting key not found.");
        }
        byte[] securedKey = Base64.decode(b64SecuredKey);
        String b64SecuredIV = userMeta.get("client-side-encryption-start");
        if (b64SecuredIV == null) {
            throw new CosClientException("Content encrypting key or IV not found.");
        }
        byte[] securedIV = Base64.decode(b64SecuredIV);
        String keyWrapAlgo = userMeta.get("client-side-encryption-wrap-alg");
        String matdescStr = userMeta.get("client-side-encryption-matdesc");
        boolean isKMS = KMSSecuredCEK.isKMSKeyWrapped(keyWrapAlgo);
        Map<String, String> metadesc = ContentCryptoMaterial.matdescFromJson(matdescStr);
        if (isKMS) {
            if (!(kekMaterialAccessor instanceof KMSEncryptionMaterialsProvider)) {
                throw new CosClientException("Must use KMSEncryptionMaterials");
            }
            KMSEncryptionMaterialsProvider kmsMaterialsProvider = (KMSEncryptionMaterialsProvider)kekMaterialAccessor;
            materials = kmsMaterialsProvider.getEncryptionMaterials();
            if (metadesc != null) {
                materials.addDescriptions(metadesc);
            }
        } else {
            EncryptionMaterials encryptionMaterials = materials = kekMaterialAccessor == null ? null : kekMaterialAccessor.getEncryptionMaterials(metadesc);
            if (materials == null) {
                throw new CosClientException("Unable to retrieve the client encryption materials");
            }
        }
        String cekAlgo = userMeta.get("client-side-encryption-cek-alg");
        boolean isRangeGet = range != null;
        ContentCryptoScheme contentCryptoScheme = ContentCryptoScheme.fromCEKAlgo(cekAlgo, isRangeGet);
        byte[] iv = ContentCryptoMaterial.decryptIV(securedIV, keyWrapAlgo, materials, securityProvider, contentCryptoScheme, kms);
        if (isRangeGet) {
            iv = contentCryptoScheme.adjustIV(iv, range[0]);
        }
        if (keyWrapExpected && keyWrapAlgo == null) {
            throw ContentCryptoMaterial.newKeyWrapException();
        }
        SecretKey cek = ContentCryptoMaterial.cek(securedKey, keyWrapAlgo, materials, securityProvider, contentCryptoScheme, kms);
        return new ContentCryptoMaterial(metadesc, securedKey, keyWrapAlgo, contentCryptoScheme.createCipherLite(cek, iv, 2, securityProvider), null);
    }

    private static CosClientException newKeyWrapException() {
        return new CosClientException("Missing key-wrap for the content-encrypting-key");
    }

    static ContentCryptoMaterial fromInstructionFile(Map<String, String> instFile, EncryptionMaterialsAccessor kekMaterialAccessor, Provider securityProvider, boolean keyWrapExpected, QCLOUDKMS kms) {
        return ContentCryptoMaterial.fromInstructionFile0(instFile, kekMaterialAccessor, securityProvider, null, keyWrapExpected, kms);
    }

    static ContentCryptoMaterial fromInstructionFile(Map<String, String> instFile, EncryptionMaterialsAccessor kekMaterialAccessor, Provider securityProvider, long[] range, boolean keyWrapExpected, QCLOUDKMS kms) {
        return ContentCryptoMaterial.fromInstructionFile0(instFile, kekMaterialAccessor, securityProvider, range, keyWrapExpected, kms);
    }

    private static ContentCryptoMaterial fromInstructionFile0(Map<String, String> instFile, EncryptionMaterialsAccessor kekMaterialAccessor, Provider securityProvider, long[] range, boolean keyWrapExpected, QCLOUDKMS kms) {
        EncryptionMaterials materials;
        String b64key = instFile.get("x-cos-key-v2");
        if (b64key == null && (b64key = instFile.get("x-cos-key")) == null) {
            throw new CosClientException("Content encrypting key not found.");
        }
        byte[] cekWrapped = Base64.decode(b64key);
        byte[] iv = Base64.decode(instFile.get("x-cos-iv"));
        if (cekWrapped == null || iv == null) {
            throw new CosClientException("Necessary encryption info not found in the instruction file " + instFile);
        }
        String keyWrapAlgo = instFile.get("x-cos-wrap-alg");
        boolean isKMS = KMSSecuredCEK.isKMSKeyWrapped(keyWrapAlgo);
        String matdescStr = instFile.get("x-cos-matdesc");
        Map<String, String> core = ContentCryptoMaterial.matdescFromJson(matdescStr);
        if (isKMS) {
            materials = new KMSEncryptionMaterials(core.get("kms_cmk_id"));
            materials.addDescriptions(core);
        } else {
            EncryptionMaterials encryptionMaterials = materials = kekMaterialAccessor == null ? null : kekMaterialAccessor.getEncryptionMaterials(core);
            if (materials == null) {
                throw new CosClientException("Unable to retrieve the encryption materials that originally encrypted object corresponding to instruction file " + instFile);
            }
        }
        String cekAlgo = instFile.get("x-cos-cek-alg");
        boolean isRangeGet = range != null;
        ContentCryptoScheme contentCryptoScheme = ContentCryptoScheme.fromCEKAlgo(cekAlgo, isRangeGet);
        if (isRangeGet) {
            iv = contentCryptoScheme.adjustIV(iv, range[0]);
        } else {
            String s;
            int tagLenActual;
            int tagLenExpected = contentCryptoScheme.getTagLengthInBits();
            if (tagLenExpected > 0 && tagLenExpected != (tagLenActual = Integer.parseInt(s = instFile.get("x-cos-tag-len")))) {
                throw new CosClientException("Unsupported tag length: " + tagLenActual + ", expected: " + tagLenExpected);
            }
        }
        if (keyWrapExpected && keyWrapAlgo == null) {
            throw ContentCryptoMaterial.newKeyWrapException();
        }
        SecretKey cek = ContentCryptoMaterial.cek(cekWrapped, keyWrapAlgo, materials, securityProvider, contentCryptoScheme, kms);
        return new ContentCryptoMaterial(core, cekWrapped, keyWrapAlgo, contentCryptoScheme.createCipherLite(cek, iv, 2, securityProvider), null);
    }

    CipherLite getCipherLite() {
        return this.cipherLite;
    }

    Map<String, String> getKEKMaterialsDescription() {
        return this.kekMaterialsDescription;
    }

    byte[] getEncryptedCEK() {
        return (byte[])this.encryptedCEK.clone();
    }

    ContentCryptoMaterial recreate(Map<String, String> newKEKMatDesc, EncryptionMaterialsAccessor accessor, COSCryptoScheme targetScheme, Provider p, QCLOUDKMS kms, CosServiceRequest req) {
        EncryptionMaterials origKEK;
        if (!this.usesKMSKey() && newKEKMatDesc.equals(this.kekMaterialsDescription)) {
            throw new SecurityException("Material description of the new KEK must differ from the current one");
        }
        if (this.usesKMSKey()) {
            origKEK = new KMSEncryptionMaterials(this.kekMaterialsDescription.get("kms_cmk_id"));
        } else {
            origKEK = accessor.getEncryptionMaterials(this.kekMaterialsDescription);
            if (origKEK == null) {
                throw new CosClientException("Unable to retrieve the origin encryption materials");
            }
        }
        EncryptionMaterials newKEK = accessor.getEncryptionMaterials(newKEKMatDesc);
        if (newKEK == null) {
            throw new CosClientException("No material available with the description " + newKEKMatDesc + " from the encryption material provider");
        }
        SecretKey cek = ContentCryptoMaterial.cek(this.encryptedCEK, this.keyWrappingAlgorithm, origKEK, p, this.getContentCryptoScheme(), kms);
        ContentCryptoMaterial output = ContentCryptoMaterial.create(cek, this.cipherLite.getIV(), newKEK, this.getContentCryptoScheme(), targetScheme, p, kms, req);
        if (Arrays.equals(output.encryptedCEK, this.encryptedCEK)) {
            throw new SecurityException("The new KEK must differ from the original");
        }
        return output;
    }

    ContentCryptoMaterial recreate(EncryptionMaterials newKEK, EncryptionMaterialsAccessor accessor, COSCryptoScheme targetScheme, Provider p, QCLOUDKMS kms, CosServiceRequest req) {
        EncryptionMaterials origKEK;
        if (!this.usesKMSKey() && newKEK.getMaterialsDescription().equals(this.kekMaterialsDescription)) {
            throw new SecurityException("Material description of the new KEK must differ from the current one");
        }
        if (this.usesKMSKey()) {
            origKEK = new KMSEncryptionMaterials(this.kekMaterialsDescription.get("kms_cmk_id"));
        } else {
            origKEK = accessor.getEncryptionMaterials(this.kekMaterialsDescription);
            if (origKEK == null) {
                throw new CosClientException("Unable to retrieve the origin encryption materials");
            }
        }
        SecretKey cek = ContentCryptoMaterial.cek(this.encryptedCEK, this.keyWrappingAlgorithm, origKEK, p, this.getContentCryptoScheme(), kms);
        ContentCryptoMaterial output = ContentCryptoMaterial.create(cek, this.cipherLite.getIV(), newKEK, this.getContentCryptoScheme(), targetScheme, p, kms, req);
        if (Arrays.equals(output.encryptedCEK, this.encryptedCEK)) {
            throw new SecurityException("The new KEK must differ from the original");
        }
        return output;
    }

    static ContentCryptoMaterial create(SecretKey cek, byte[] iv, EncryptionMaterials kekMaterials, ContentCryptoScheme contentCryptoScheme, COSCryptoScheme targetScheme, Provider provider, QCLOUDKMS kms, CosServiceRequest req) {
        return ContentCryptoMaterial.doCreate(cek, iv, kekMaterials, contentCryptoScheme, targetScheme, provider, kms, req);
    }

    static ContentCryptoMaterial create(SecretKey cek, byte[] iv, EncryptionMaterials kekMaterials, COSCryptoScheme scheme, Provider provider, QCLOUDKMS kms, CosServiceRequest req) {
        return ContentCryptoMaterial.doCreate(cek, iv, kekMaterials, scheme.getContentCryptoScheme(), scheme, provider, kms, req);
    }

    private static ContentCryptoMaterial doCreate(SecretKey cek, byte[] iv, EncryptionMaterials kekMaterials, ContentCryptoScheme contentCryptoScheme, COSCryptoScheme targetCOSCryptoScheme, Provider provider, QCLOUDKMS kms, CosServiceRequest req) {
        SecuredCEK cekSecured = ContentCryptoMaterial.secureCEK(cek, kekMaterials, targetCOSCryptoScheme.getKeyWrapScheme(), targetCOSCryptoScheme.getSecureRandom(), provider, kms, req);
        byte[] securedIV = ContentCryptoMaterial.encryptIV(iv, kekMaterials, targetCOSCryptoScheme.getKeyWrapScheme(), targetCOSCryptoScheme.getSecureRandom(), provider, kms, req);
        return ContentCryptoMaterial.wrap(cek, iv, contentCryptoScheme, provider, cekSecured, securedIV);
    }

    public static ContentCryptoMaterial wrap(SecretKey cek, byte[] iv, ContentCryptoScheme contentCryptoScheme, Provider provider, SecuredCEK cekSecured, byte[] securedIV) {
        return new ContentCryptoMaterial(cekSecured.getMaterialDescription(), cekSecured.getEncrypted(), cekSecured.getKeyWrapAlgorithm(), contentCryptoScheme.createCipherLite(cek, iv, 1, provider), securedIV);
    }

    private static SecuredCEK secureCEK(SecretKey cek, EncryptionMaterials materials, COSKeyWrapScheme kwScheme, SecureRandom srand, Provider p, QCLOUDKMS kms, CosServiceRequest req) {
        if (materials.isKMSEnabled()) {
            Map<String, String> matdesc = ContentCryptoMaterial.mergeMaterialDescriptions(materials, req);
            EncryptRequest encryptRequest = new EncryptRequest();
            try {
                ObjectMapper mapper = new ObjectMapper();
                encryptRequest.setEncryptionContext(mapper.writeValueAsString(matdesc));
            }
            catch (JsonProcessingException e) {
                throw new CosClientException("encrypt request set encryption context got json processing exception", e);
            }
            encryptRequest.setKeyId(materials.getCustomerMasterKeyId());
            encryptRequest.setPlaintext(cek.getEncoded().toString());
            EncryptResponse encryptResponse = kms.encrypt(encryptRequest);
            byte[] keyBlob = encryptResponse.getCiphertextBlob().getBytes();
            return new KMSSecuredCEK(keyBlob, matdesc);
        }
        Map<String, String> matdesc = materials.getMaterialsDescription();
        Key kek = materials.getKeyPair() != null ? materials.getKeyPair().getPublic() : materials.getSymmetricKey();
        String keyWrapAlgo = kwScheme.getKeyWrapAlgorithm(kek);
        try {
            Cipher cipher = p == null ? Cipher.getInstance(keyWrapAlgo) : Cipher.getInstance(keyWrapAlgo, p);
            cipher.init(3, kek, srand);
            return new SecuredCEK(cipher.wrap(cek), keyWrapAlgo, matdesc);
        }
        catch (Exception e) {
            throw new CosClientException("Unable to encrypt symmetric key", e);
        }
    }

    public static byte[] encryptIV(byte[] iv, EncryptionMaterials materials, COSKeyWrapScheme kwScheme, SecureRandom srand, Provider p, QCLOUDKMS kms, CosServiceRequest req) {
        if (materials.isKMSEnabled()) {
            Map<String, String> matdesc = ContentCryptoMaterial.mergeMaterialDescriptions(materials, req);
            EncryptRequest encryptRequest = new EncryptRequest();
            try {
                ObjectMapper mapper = new ObjectMapper();
                encryptRequest.setEncryptionContext(mapper.writeValueAsString(matdesc));
            }
            catch (JsonProcessingException e) {
                throw new CosClientException("encrypt request set encryption context got json processing exception", e);
            }
            encryptRequest.setKeyId(materials.getCustomerMasterKeyId());
            encryptRequest.setPlaintext(Base64.encodeAsString(iv));
            EncryptResponse encryptResponse = kms.encrypt(encryptRequest);
            String cipherIV = encryptResponse.getCiphertextBlob();
            return cipherIV.getBytes(Charset.forName("UTF-8"));
        }
        Key kek = materials.getKeyPair() != null ? materials.getKeyPair().getPublic() : materials.getSymmetricKey();
        String keyWrapAlgo = kwScheme.getKeyWrapAlgorithm(kek);
        try {
            Cipher cipher = p == null ? Cipher.getInstance(keyWrapAlgo) : Cipher.getInstance(keyWrapAlgo, p);
            cipher.init(1, kek, srand);
            return cipher.doFinal(iv);
        }
        catch (Exception e) {
            throw new CosClientException("Unable to encrypt IV", e);
        }
    }

    public static byte[] decryptIV(byte[] iv, String keyWrapAlgo, EncryptionMaterials materials, Provider securityProvider, ContentCryptoScheme contentCryptoScheme, QCLOUDKMS kms) {
        Key kek;
        if (materials.isKMSEnabled()) {
            DecryptRequest decryptReq = new DecryptRequest();
            Map<String, String> materialDesc = materials.getMaterialsDescription();
            try {
                ObjectMapper mapper = new ObjectMapper();
                decryptReq.setEncryptionContext(mapper.writeValueAsString(materialDesc));
            }
            catch (JsonProcessingException e) {
                throw new CosClientException("decrypt request set encryption context got json processing exception", e);
            }
            decryptReq.setCiphertextBlob(new String(iv, Charset.forName("UTF-8")));
            DecryptResponse decryptRes = kms.decrypt(decryptReq);
            return Base64.decode(decryptRes.getPlaintext());
        }
        if (materials.getKeyPair() != null ? (kek = materials.getKeyPair().getPrivate()) == null : (kek = materials.getSymmetricKey()) == null) {
            throw new CosClientException("Key encrypting key not available");
        }
        try {
            if (keyWrapAlgo != null) {
                Cipher cipher = securityProvider == null ? Cipher.getInstance(keyWrapAlgo) : Cipher.getInstance(keyWrapAlgo, securityProvider);
                cipher.init(2, kek);
                return cipher.doFinal(iv);
            }
            Cipher cipher = securityProvider != null ? Cipher.getInstance(kek.getAlgorithm(), securityProvider) : Cipher.getInstance(kek.getAlgorithm());
            cipher.init(2, kek);
            return cipher.doFinal(iv);
        }
        catch (Exception e) {
            throw new CosClientException("Unable to decrypt symmetric key from object metadata", e);
        }
    }

    static Map<String, String> mergeMaterialDescriptions(EncryptionMaterials materials, CosServiceRequest req) {
        MaterialsDescriptionProvider mdp;
        Map<String, String> matdesc_req;
        Map<String, String> matdesc = materials.getMaterialsDescription();
        if (req instanceof MaterialsDescriptionProvider && (matdesc_req = (mdp = (MaterialsDescriptionProvider)((Object)req)).getMaterialsDescription()) != null) {
            matdesc = new TreeMap<String, String>(matdesc);
            matdesc.putAll(matdesc_req);
        }
        return matdesc;
    }
}

