/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.plugin.storage.api;

import com.google.common.base.Preconditions;
import com.google.common.io.Files;
import java.io.File;
import org.apache.commons.lang3.StringUtils;
import org.apache.dolphinscheduler.common.utils.FileUtils;
import org.apache.dolphinscheduler.plugin.storage.api.ResourceMetadata;
import org.apache.dolphinscheduler.plugin.storage.api.StorageOperator;
import org.apache.dolphinscheduler.spi.enums.ResourceType;

public abstract class AbstractStorageOperator
implements StorageOperator {
    protected final String resourceBaseAbsolutePath;

    public AbstractStorageOperator(String resourceBaseAbsolutePath) {
        Preconditions.checkNotNull((Object)resourceBaseAbsolutePath, (Object)"Resource upload path should not be null");
        this.resourceBaseAbsolutePath = resourceBaseAbsolutePath;
    }

    @Override
    public ResourceMetadata getResourceMetaData(String resourceAbsolutePath) {
        String storageBaseDirectory = this.getStorageBaseDirectory();
        String resourceSegment = StringUtils.substringAfter((String)resourceAbsolutePath, (String)storageBaseDirectory);
        String[] segments = StringUtils.split((String)resourceSegment, (String)File.separator, (int)3);
        if (segments.length == 0) {
            throw new IllegalArgumentException("Invalid resource path: " + resourceAbsolutePath);
        }
        return ResourceMetadata.builder().resourceAbsolutePath(resourceAbsolutePath).resourceBaseDirectory(storageBaseDirectory).isDirectory(Files.getFileExtension((String)resourceAbsolutePath).isEmpty()).tenant(segments[0]).resourceType(ResourceType.FILE).resourceRelativePath(segments.length == 2 ? "/" : segments[2]).resourceParentAbsolutePath(StringUtils.substringBeforeLast((String)resourceAbsolutePath, (String)File.separator)).build();
    }

    @Override
    public String getStorageBaseDirectory() {
        return this.resourceBaseAbsolutePath;
    }

    @Override
    public String getStorageBaseDirectory(String tenantCode) {
        if (StringUtils.isEmpty((CharSequence)tenantCode)) {
            throw new IllegalArgumentException("Tenant code should not be empty");
        }
        return FileUtils.concatFilePath((String[])new String[]{this.getStorageBaseDirectory(), tenantCode});
    }

    @Override
    public String getStorageBaseDirectory(String tenantCode, ResourceType resourceType) {
        String resourceBaseDirectory;
        String tenantBaseDirectory = this.getStorageBaseDirectory(tenantCode);
        if (resourceType == null) {
            throw new IllegalArgumentException("Resource type should not be null");
        }
        switch (resourceType) {
            case FILE: {
                resourceBaseDirectory = FileUtils.concatFilePath((String[])new String[]{tenantBaseDirectory, "resources"});
                break;
            }
            case ALL: {
                resourceBaseDirectory = tenantBaseDirectory;
                break;
            }
            default: {
                throw new IllegalArgumentException("Resource type: " + resourceType + " not supported");
            }
        }
        return resourceBaseDirectory;
    }

    @Override
    public String getStorageFileAbsolutePath(String tenantCode, String fileName) {
        return FileUtils.concatFilePath((String[])new String[]{this.getStorageBaseDirectory(tenantCode, ResourceType.FILE), fileName});
    }

    protected void exceptionIfPathEmpty(String resourceAbsolutePath) {
        if (StringUtils.isEmpty((CharSequence)resourceAbsolutePath)) {
            throw new IllegalArgumentException("Resource path should not be empty");
        }
    }

    protected void exceptionIfPathNotUnderStorageBaseDir(String resourceAbsolutePath) {
        String storageBaseDirectory = this.getStorageBaseDirectory();
        if (!resourceAbsolutePath.startsWith(storageBaseDirectory)) {
            throw new IllegalArgumentException("Resource path: " + resourceAbsolutePath + " is not under storage base directory: " + storageBaseDirectory);
        }
    }
}

