/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.datafactory.models.CmkIdentityDefinition;
import com.fasterxml.jackson.annotation.JsonProperty;

public final class EncryptionConfiguration {
    @JsonProperty(value="keyName", required=true)
    private String keyName;
    @JsonProperty(value="vaultBaseUrl", required=true)
    private String vaultBaseUrl;
    @JsonProperty(value="keyVersion")
    private String keyVersion;
    @JsonProperty(value="identity")
    private CmkIdentityDefinition identity;
    private static final ClientLogger LOGGER = new ClientLogger(EncryptionConfiguration.class);

    public String keyName() {
        return this.keyName;
    }

    public EncryptionConfiguration withKeyName(String keyName) {
        this.keyName = keyName;
        return this;
    }

    public String vaultBaseUrl() {
        return this.vaultBaseUrl;
    }

    public EncryptionConfiguration withVaultBaseUrl(String vaultBaseUrl) {
        this.vaultBaseUrl = vaultBaseUrl;
        return this;
    }

    public String keyVersion() {
        return this.keyVersion;
    }

    public EncryptionConfiguration withKeyVersion(String keyVersion) {
        this.keyVersion = keyVersion;
        return this;
    }

    public CmkIdentityDefinition identity() {
        return this.identity;
    }

    public EncryptionConfiguration withIdentity(CmkIdentityDefinition identity) {
        this.identity = identity;
        return this;
    }

    public void validate() {
        if (this.keyName() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property keyName in model EncryptionConfiguration"));
        }
        if (this.vaultBaseUrl() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property vaultBaseUrl in model EncryptionConfiguration"));
        }
        if (this.identity() != null) {
            this.identity().validate();
        }
    }
}

