/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.eventhubs.fluent.models;

import com.azure.core.management.ProxyResource;
import com.azure.core.management.SystemData;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.eventhubs.fluent.models.EventhubProperties;
import com.azure.resourcemanager.eventhubs.models.CaptureDescription;
import com.azure.resourcemanager.eventhubs.models.EntityStatus;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.OffsetDateTime;
import java.util.List;

public final class EventhubInner
extends ProxyResource {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(EventhubInner.class);
    @JsonProperty(value="properties")
    private EventhubProperties innerProperties;
    @JsonProperty(value="systemData", access=JsonProperty.Access.WRITE_ONLY)
    private SystemData systemData;
    @JsonProperty(value="location", access=JsonProperty.Access.WRITE_ONLY)
    private String location;

    private EventhubProperties innerProperties() {
        return this.innerProperties;
    }

    public SystemData systemData() {
        return this.systemData;
    }

    public String location() {
        return this.location;
    }

    public List<String> partitionIds() {
        return this.innerProperties() == null ? null : this.innerProperties().partitionIds();
    }

    public OffsetDateTime createdAt() {
        return this.innerProperties() == null ? null : this.innerProperties().createdAt();
    }

    public OffsetDateTime updatedAt() {
        return this.innerProperties() == null ? null : this.innerProperties().updatedAt();
    }

    public Long messageRetentionInDays() {
        return this.innerProperties() == null ? null : this.innerProperties().messageRetentionInDays();
    }

    public EventhubInner withMessageRetentionInDays(Long messageRetentionInDays) {
        if (this.innerProperties() == null) {
            this.innerProperties = new EventhubProperties();
        }
        this.innerProperties().withMessageRetentionInDays(messageRetentionInDays);
        return this;
    }

    public Long partitionCount() {
        return this.innerProperties() == null ? null : this.innerProperties().partitionCount();
    }

    public EventhubInner withPartitionCount(Long partitionCount) {
        if (this.innerProperties() == null) {
            this.innerProperties = new EventhubProperties();
        }
        this.innerProperties().withPartitionCount(partitionCount);
        return this;
    }

    public EntityStatus status() {
        return this.innerProperties() == null ? null : this.innerProperties().status();
    }

    public EventhubInner withStatus(EntityStatus status) {
        if (this.innerProperties() == null) {
            this.innerProperties = new EventhubProperties();
        }
        this.innerProperties().withStatus(status);
        return this;
    }

    public CaptureDescription captureDescription() {
        return this.innerProperties() == null ? null : this.innerProperties().captureDescription();
    }

    public EventhubInner withCaptureDescription(CaptureDescription captureDescription) {
        if (this.innerProperties() == null) {
            this.innerProperties = new EventhubProperties();
        }
        this.innerProperties().withCaptureDescription(captureDescription);
        return this;
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }
}

