/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.api.validator.resource;

import java.io.File;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.dolphinscheduler.api.dto.resources.RenameDirectoryDto;
import org.apache.dolphinscheduler.api.dto.resources.RenameDirectoryRequest;
import org.apache.dolphinscheduler.api.validator.ITransformer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class RenameDirectoryRequestTransformer
implements ITransformer<RenameDirectoryRequest, RenameDirectoryDto> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RenameDirectoryRequestTransformer.class);

    @Override
    public RenameDirectoryDto transform(RenameDirectoryRequest renameDirectoryRequest) {
        String originDirectoryAbsolutePath = renameDirectoryRequest.getDirectoryAbsolutePath();
        String targetDirectoryName = renameDirectoryRequest.getNewDirectoryName();
        String targetDirectoryAbsolutePath = this.getTargetDirectoryAbsolutePath(originDirectoryAbsolutePath, targetDirectoryName);
        return RenameDirectoryDto.builder().loginUser(renameDirectoryRequest.getLoginUser()).originDirectoryAbsolutePath(originDirectoryAbsolutePath).targetDirectoryAbsolutePath(targetDirectoryAbsolutePath).build();
    }

    private String getTargetDirectoryAbsolutePath(String originDirectoryAbsolutePath, String targetDirectoryName) {
        String originDirectoryParentAbsolutePath = StringUtils.substringBeforeLast((String)originDirectoryAbsolutePath, (String)File.separator);
        return originDirectoryParentAbsolutePath + File.separator + targetDirectoryName;
    }
}

