/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.api.service.impl;

import java.text.MessageFormat;
import java.util.Date;
import java.util.Map;
import java.util.Objects;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.dolphinscheduler.api.enums.Status;
import org.apache.dolphinscheduler.api.exceptions.ServiceException;
import org.apache.dolphinscheduler.api.permission.ResourcePermissionCheckService;
import org.apache.dolphinscheduler.api.service.BaseService;
import org.apache.dolphinscheduler.api.utils.Result;
import org.apache.dolphinscheduler.common.enums.AuthorizationType;
import org.apache.dolphinscheduler.common.enums.UserType;
import org.apache.dolphinscheduler.common.utils.DateUtils;
import org.apache.dolphinscheduler.dao.entity.User;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class BaseServiceImpl
implements BaseService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BaseServiceImpl.class);
    @Autowired
    protected ResourcePermissionCheckService resourcePermissionCheckService;

    @Override
    public boolean isAdmin(User user) {
        return user.getUserType() == UserType.ADMIN_USER;
    }

    @Override
    public boolean isNotAdmin(User loginUser) {
        return !this.isAdmin(loginUser);
    }

    @Override
    public void putMsg(Map<String, Object> result, Status status, Object ... statusParams) {
        result.put("status", (Object)status);
        if (statusParams != null && statusParams.length > 0) {
            result.put("msg", MessageFormat.format(status.getMsg(), statusParams));
        } else {
            result.put("msg", status.getMsg());
        }
    }

    public void putMsg(Result result, Status status, Object ... statusParams) {
        result.setCode(status.getCode());
        if (statusParams != null && statusParams.length > 0) {
            result.setMsg(MessageFormat.format(status.getMsg(), statusParams));
        } else {
            result.setMsg(status.getMsg());
        }
    }

    @Override
    public boolean check(Map<String, Object> result, boolean bool, Status userNoOperationPerm) {
        if (bool) {
            result.put("status", (Object)userNoOperationPerm);
            result.put("msg", userNoOperationPerm.getMsg());
            return true;
        }
        return false;
    }

    @Override
    public boolean canOperator(User operateUser, int createUserId) {
        return operateUser.getId() == createUserId || this.isAdmin(operateUser);
    }

    @Override
    public boolean canOperatorPermissions(User user, Object[] ids, AuthorizationType type, String permissionKey) {
        boolean operationPermissionCheck = this.resourcePermissionCheckService.operationPermissionCheck(type, user.getId(), permissionKey, log);
        boolean resourcePermissionCheck = this.resourcePermissionCheckService.resourcePermissionCheck(type, ids, user.getUserType().equals((Object)UserType.ADMIN_USER) ? 0 : user.getId(), log);
        return operationPermissionCheck && resourcePermissionCheck;
    }

    @Override
    public Date checkAndParseDateParameters(String startDateStr) throws ServiceException {
        Date start = null;
        if (!StringUtils.isEmpty((CharSequence)startDateStr) && Objects.isNull(start = DateUtils.stringToDate((String)startDateStr))) {
            log.warn("Parameter startDateStr is invalid.");
            throw new ServiceException(Status.REQUEST_PARAMS_NOT_VALID_ERROR, "startDate,endDate");
        }
        return start;
    }

    @Override
    public boolean checkDescriptionLength(String description) {
        return description != null && description.codePointCount(0, description.length()) > 255;
    }

    protected Date transformDate(String dateStr) {
        Date date = DateUtils.stringToDate((String)dateStr);
        if (date == null) {
            throw new IllegalArgumentException("dateStr: [" + dateStr + "] is invalid");
        }
        return date;
    }
}

