/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.scheduler.quartz;

import com.google.common.collect.Sets;
import java.util.Set;
import lombok.Generated;
import org.apache.dolphinscheduler.dao.entity.Schedule;
import org.apache.dolphinscheduler.scheduler.api.SchedulerApi;
import org.apache.dolphinscheduler.scheduler.api.SchedulerException;
import org.apache.dolphinscheduler.scheduler.api.SchedulerExceptionEnum;
import org.apache.dolphinscheduler.scheduler.quartz.QuartzCornTriggerBuilder;
import org.apache.dolphinscheduler.scheduler.quartz.QuartzJobDetailBuilder;
import org.apache.dolphinscheduler.scheduler.quartz.QuartzJobKey;
import org.apache.dolphinscheduler.scheduler.quartz.exception.QuartzSchedulerExceptionEnum;
import org.quartz.CronTrigger;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.quartz.Scheduler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QuartzScheduler
implements SchedulerApi {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(QuartzScheduler.class);
    private final Scheduler scheduler;

    public QuartzScheduler(Scheduler scheduler) {
        this.scheduler = scheduler;
    }

    public void start() throws SchedulerException {
        try {
            this.scheduler.start();
        }
        catch (Exception e) {
            throw new SchedulerException((SchedulerExceptionEnum)QuartzSchedulerExceptionEnum.QUARTZ_SCHEDULER_START_ERROR, (Throwable)e);
        }
    }

    public void insertOrUpdateScheduleTask(int projectId, Schedule schedule) throws SchedulerException {
        try {
            CronTrigger cornTrigger = QuartzCornTriggerBuilder.newBuilder().withProjectId(projectId).withSchedule(schedule).build();
            JobDetail jobDetail = QuartzJobDetailBuilder.newBuilder().withProjectId(projectId).withSchedule(schedule.getId()).build();
            this.scheduler.scheduleJob(jobDetail, (Set)Sets.newHashSet((Object[])new CronTrigger[]{cornTrigger}), true);
            log.info("Success scheduleJob: {} with trigger: {} at quartz", (Object)jobDetail, (Object)cornTrigger);
        }
        catch (Exception e) {
            log.error("Failed to add scheduler task, projectId: {}, scheduler: {}", new Object[]{projectId, schedule, e});
            throw new SchedulerException((SchedulerExceptionEnum)QuartzSchedulerExceptionEnum.QUARTZ_UPSERT_JOB_ERROR, (Throwable)e);
        }
    }

    public void deleteScheduleTask(int projectId, int scheduleId) throws SchedulerException {
        JobKey jobKey = QuartzJobKey.of(projectId, scheduleId).toJobKey();
        try {
            if (this.scheduler.checkExists(jobKey)) {
                log.info("Try to delete scheduler task, projectId: {}, schedulerId: {}", (Object)projectId, (Object)scheduleId);
                this.scheduler.deleteJob(jobKey);
            }
        }
        catch (Exception e) {
            log.error("Failed to delete scheduler task, projectId: {}, schedulerId: {}", new Object[]{projectId, scheduleId, e});
            throw new SchedulerException((SchedulerExceptionEnum)QuartzSchedulerExceptionEnum.QUARTZ_DELETE_JOB_ERROR, (Throwable)e);
        }
    }

    public void close() {
        try {
            this.scheduler.shutdown();
        }
        catch (Exception e) {
            throw new SchedulerException((SchedulerExceptionEnum)QuartzSchedulerExceptionEnum.QUARTZ_SCHEDULER_SHOWDOWN_ERROR, (Throwable)e);
        }
    }
}

