/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.cdn.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.cdn.models.AfdCertificateType;
import com.azure.resourcemanager.cdn.models.AfdMinimumTlsVersion;
import com.azure.resourcemanager.cdn.models.ResourceReference;
import com.fasterxml.jackson.annotation.JsonProperty;

public final class AfdDomainHttpsParameters {
    @JsonProperty(value="certificateType", required=true)
    private AfdCertificateType certificateType;
    @JsonProperty(value="minimumTlsVersion")
    private AfdMinimumTlsVersion minimumTlsVersion;
    @JsonProperty(value="secret")
    private ResourceReference secret;
    private static final ClientLogger LOGGER = new ClientLogger(AfdDomainHttpsParameters.class);

    public AfdCertificateType certificateType() {
        return this.certificateType;
    }

    public AfdDomainHttpsParameters withCertificateType(AfdCertificateType certificateType) {
        this.certificateType = certificateType;
        return this;
    }

    public AfdMinimumTlsVersion minimumTlsVersion() {
        return this.minimumTlsVersion;
    }

    public AfdDomainHttpsParameters withMinimumTlsVersion(AfdMinimumTlsVersion minimumTlsVersion) {
        this.minimumTlsVersion = minimumTlsVersion;
        return this;
    }

    public ResourceReference secret() {
        return this.secret;
    }

    public AfdDomainHttpsParameters withSecret(ResourceReference secret) {
        this.secret = secret;
        return this;
    }

    public void validate() {
        if (this.certificateType() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property certificateType in model AfdDomainHttpsParameters"));
        }
        if (this.secret() != null) {
            this.secret().validate();
        }
    }
}

