/*
 * Decompiled with CFR 0.152.
 */
package com.qcloud.cos.model;

import com.qcloud.cos.internal.CosServiceRequest;
import com.qcloud.cos.internal.crypto.EncryptionMaterials;
import com.qcloud.cos.internal.crypto.EncryptionMaterialsFactory;
import com.qcloud.cos.model.AccessControlList;
import com.qcloud.cos.model.COSObject;
import com.qcloud.cos.model.COSObjectId;
import com.qcloud.cos.model.CannedAccessControlList;
import com.qcloud.cos.model.InstructionFileId;
import com.qcloud.cos.model.MaterialsDescriptionProvider;
import com.qcloud.cos.model.PutObjectRequest;
import com.qcloud.cos.model.StorageClass;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class PutInstructionFileRequest
extends CosServiceRequest
implements MaterialsDescriptionProvider,
EncryptionMaterialsFactory {
    private final COSObjectId cosObjectId;
    private final EncryptionMaterials encryptionMaterials;
    private final Map<String, String> matDesc;
    private final String suffix;
    private CannedAccessControlList cannedAcl;
    private AccessControlList accessControlList;
    private String redirectLocation;
    private String storageClass;

    public PutInstructionFileRequest(COSObjectId cosObjectId, Map<String, String> matDesc, String suffix) {
        if (cosObjectId == null || cosObjectId instanceof InstructionFileId) {
            throw new IllegalArgumentException("Invalid cos object id");
        }
        if (suffix == null || suffix.trim().isEmpty()) {
            throw new IllegalArgumentException("suffix must be specified");
        }
        this.cosObjectId = cosObjectId;
        Map<String, String> md = matDesc == null ? Collections.EMPTY_MAP : Collections.unmodifiableMap(new HashMap<String, String>(matDesc));
        this.matDesc = md;
        this.suffix = suffix;
        this.encryptionMaterials = null;
    }

    public PutInstructionFileRequest(COSObjectId cosObjectId, EncryptionMaterials encryptionMaterials, String suffix) {
        if (cosObjectId == null || cosObjectId instanceof InstructionFileId) {
            throw new IllegalArgumentException("Invalid cos object id");
        }
        if (suffix == null || suffix.trim().isEmpty()) {
            throw new IllegalArgumentException("suffix must be specified");
        }
        if (encryptionMaterials == null) {
            throw new IllegalArgumentException("encryption materials must be specified");
        }
        this.cosObjectId = cosObjectId;
        this.suffix = suffix;
        this.encryptionMaterials = encryptionMaterials;
        this.matDesc = null;
    }

    public COSObjectId getCOSObjectId() {
        return this.cosObjectId;
    }

    @Override
    public Map<String, String> getMaterialsDescription() {
        return this.matDesc == null ? this.encryptionMaterials.getMaterialsDescription() : this.matDesc;
    }

    @Override
    public EncryptionMaterials getEncryptionMaterials() {
        return this.encryptionMaterials;
    }

    public String getSuffix() {
        return this.suffix;
    }

    public CannedAccessControlList getCannedAcl() {
        return this.cannedAcl;
    }

    public void setCannedAcl(CannedAccessControlList cannedAcl) {
        this.cannedAcl = cannedAcl;
    }

    public PutInstructionFileRequest withCannedAcl(CannedAccessControlList cannedAcl) {
        this.setCannedAcl(cannedAcl);
        return this;
    }

    public AccessControlList getAccessControlList() {
        return this.accessControlList;
    }

    public void setAccessControlList(AccessControlList accessControlList) {
        this.accessControlList = accessControlList;
    }

    public PutInstructionFileRequest withAccessControlList(AccessControlList accessControlList) {
        this.setAccessControlList(accessControlList);
        return this;
    }

    public String getRedirectLocation() {
        return this.redirectLocation;
    }

    public void setRedirectLocation(String redirectLocation) {
        this.redirectLocation = redirectLocation;
    }

    public PutInstructionFileRequest withRedirectLocation(String redirectLocation) {
        this.redirectLocation = redirectLocation;
        return this;
    }

    public String getStorageClass() {
        return this.storageClass;
    }

    public void setStorageClass(String storageClass) {
        this.storageClass = storageClass;
    }

    public PutInstructionFileRequest withStorageClass(String storageClass) {
        this.setStorageClass(storageClass);
        return this;
    }

    public void setStorageClass(StorageClass storageClass) {
        this.storageClass = storageClass.toString();
    }

    public PutInstructionFileRequest withStorageClass(StorageClass storageClass) {
        this.setStorageClass(storageClass);
        return this;
    }

    public PutObjectRequest createPutObjectRequest(COSObject cosObject) {
        if (!cosObject.getBucketName().equals(this.cosObjectId.getBucket()) || !cosObject.getKey().equals(this.cosObjectId.getKey())) {
            throw new IllegalArgumentException("cosObject passed inconsistent with the instruction file being created");
        }
        InstructionFileId ifid = this.cosObjectId.instructionFileId(this.suffix);
        return (PutObjectRequest)new PutObjectRequest(ifid.getBucket(), ifid.getKey(), null).withRedirectLocation(this.redirectLocation).withAccessControlList(this.accessControlList).withCannedAcl(this.cannedAcl).withStorageClass(this.storageClass).withGeneralProgressListener(this.getGeneralProgressListener());
    }
}

