/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.plugin.registry.jdbc.server;

import java.util.Date;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import lombok.Generated;
import org.apache.dolphinscheduler.common.thread.ThreadUtils;
import org.apache.dolphinscheduler.plugin.registry.jdbc.JdbcRegistryProperties;
import org.apache.dolphinscheduler.plugin.registry.jdbc.LockUtils;
import org.apache.dolphinscheduler.plugin.registry.jdbc.model.DTO.JdbcRegistryLockDTO;
import org.apache.dolphinscheduler.plugin.registry.jdbc.repository.JdbcRegistryLockRepository;
import org.apache.dolphinscheduler.plugin.registry.jdbc.server.IJdbcRegistryLockManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DuplicateKeyException;

public class JdbcRegistryLockManager
implements IJdbcRegistryLockManager {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(JdbcRegistryLockManager.class);
    private final JdbcRegistryProperties jdbcRegistryProperties;
    private final JdbcRegistryLockRepository jdbcRegistryLockRepository;
    private final Map<String, LockEntry> jdbcRegistryLockHolderMap = new ConcurrentHashMap<String, LockEntry>();

    public JdbcRegistryLockManager(JdbcRegistryProperties jdbcRegistryProperties, JdbcRegistryLockRepository jdbcRegistryLockRepository) {
        this.jdbcRegistryProperties = jdbcRegistryProperties;
        this.jdbcRegistryLockRepository = jdbcRegistryLockRepository;
    }

    @Override
    public void acquireJdbcRegistryLock(Long clientId, String lockKey) {
        String lockOwner = LockUtils.getLockOwner();
        while (!this.tryReenterLock(lockKey, lockOwner)) {
            JdbcRegistryLockDTO jdbcRegistryLock = JdbcRegistryLockDTO.builder().lockKey(lockKey).clientId(clientId).lockOwner(lockOwner).createTime(new Date()).build();
            try {
                this.jdbcRegistryLockRepository.insert(jdbcRegistryLock);
                if (jdbcRegistryLock != null) {
                    this.jdbcRegistryLockHolderMap.put(lockKey, LockEntry.builder().lockKey(lockKey).lockOwner(lockOwner).jdbcRegistryLock(jdbcRegistryLock).build());
                    return;
                }
                log.debug("{} acquire the lock {} success", (Object)lockOwner, (Object)lockKey);
            }
            catch (DuplicateKeyException duplicateKeyException) {
                continue;
            }
            log.debug("{} acquire the lock {} failed try again", (Object)lockOwner, (Object)lockKey);
            ThreadUtils.sleep((long)this.jdbcRegistryProperties.getHeartbeatRefreshInterval().toMillis());
        }
        return;
    }

    private boolean tryReenterLock(String lockKey, String lockAcquirer) {
        LockEntry lockEntry = this.jdbcRegistryLockHolderMap.get(lockKey);
        if (lockEntry != null && lockAcquirer.equals(lockEntry.getLockOwner())) {
            lockEntry.lockCount.incrementAndGet();
            return true;
        }
        return false;
    }

    @Override
    public boolean acquireJdbcRegistryLock(Long clientId, String lockKey, long timeout) {
        String lockOwner = LockUtils.getLockOwner();
        long start = System.currentTimeMillis();
        while (System.currentTimeMillis() - start <= timeout) {
            if (this.tryReenterLock(lockKey, lockOwner)) {
                return true;
            }
            JdbcRegistryLockDTO jdbcRegistryLock = JdbcRegistryLockDTO.builder().lockKey(lockKey).clientId(clientId).lockOwner(lockOwner).createTime(new Date()).build();
            try {
                this.jdbcRegistryLockRepository.insert(jdbcRegistryLock);
                if (jdbcRegistryLock != null) {
                    this.jdbcRegistryLockHolderMap.put(lockKey, LockEntry.builder().lockKey(lockKey).lockOwner(lockOwner).jdbcRegistryLock(jdbcRegistryLock).build());
                    return true;
                }
                log.debug("{} acquire the lock {} success", (Object)lockOwner, (Object)lockKey);
            }
            catch (DuplicateKeyException duplicateKeyException) {
                continue;
            }
            log.debug("{} acquire the lock {} failed try again", (Object)lockOwner, (Object)lockKey);
            ThreadUtils.sleep((long)this.jdbcRegistryProperties.getHeartbeatRefreshInterval().toMillis());
        }
        return false;
    }

    @Override
    public void releaseJdbcRegistryLock(Long clientId, String lockKey) {
        String lockOwner = LockUtils.getLockOwner();
        LockEntry lockEntry = this.jdbcRegistryLockHolderMap.get(lockKey);
        if (lockEntry == null || !lockOwner.equals(lockEntry.getLockOwner())) {
            return;
        }
        if (!clientId.equals(lockEntry.getJdbcRegistryLock().getClientId())) {
            throw new UnsupportedOperationException("The client " + clientId + " is not the lock owner of the lock: " + lockKey);
        }
        int newLockCount = lockEntry.lockCount.decrementAndGet();
        if (newLockCount > 0) {
            return;
        }
        if (newLockCount < 0) {
            throw new IllegalMonitorStateException("Jdbc lock count has gone negative for lock: " + lockKey);
        }
        this.jdbcRegistryLockRepository.deleteById(lockEntry.getJdbcRegistryLock().getId());
        this.jdbcRegistryLockHolderMap.remove(lockKey);
    }

    public static class LockEntry {
        private String lockKey;
        private String lockOwner;
        final AtomicInteger lockCount = new AtomicInteger(1);
        private JdbcRegistryLockDTO jdbcRegistryLock;

        @Generated
        public static LockEntryBuilder builder() {
            return new LockEntryBuilder();
        }

        @Generated
        public String getLockKey() {
            return this.lockKey;
        }

        @Generated
        public String getLockOwner() {
            return this.lockOwner;
        }

        @Generated
        public AtomicInteger getLockCount() {
            return this.lockCount;
        }

        @Generated
        public JdbcRegistryLockDTO getJdbcRegistryLock() {
            return this.jdbcRegistryLock;
        }

        @Generated
        public void setLockKey(String lockKey) {
            this.lockKey = lockKey;
        }

        @Generated
        public void setLockOwner(String lockOwner) {
            this.lockOwner = lockOwner;
        }

        @Generated
        public void setJdbcRegistryLock(JdbcRegistryLockDTO jdbcRegistryLock) {
            this.jdbcRegistryLock = jdbcRegistryLock;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof LockEntry)) {
                return false;
            }
            LockEntry other = (LockEntry)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$lockKey = this.getLockKey();
            String other$lockKey = other.getLockKey();
            if (this$lockKey == null ? other$lockKey != null : !this$lockKey.equals(other$lockKey)) {
                return false;
            }
            String this$lockOwner = this.getLockOwner();
            String other$lockOwner = other.getLockOwner();
            if (this$lockOwner == null ? other$lockOwner != null : !this$lockOwner.equals(other$lockOwner)) {
                return false;
            }
            AtomicInteger this$lockCount = this.getLockCount();
            AtomicInteger other$lockCount = other.getLockCount();
            if (this$lockCount == null ? other$lockCount != null : !this$lockCount.equals(other$lockCount)) {
                return false;
            }
            JdbcRegistryLockDTO this$jdbcRegistryLock = this.getJdbcRegistryLock();
            JdbcRegistryLockDTO other$jdbcRegistryLock = other.getJdbcRegistryLock();
            return !(this$jdbcRegistryLock == null ? other$jdbcRegistryLock != null : !((Object)this$jdbcRegistryLock).equals(other$jdbcRegistryLock));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof LockEntry;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $lockKey = this.getLockKey();
            result = result * 59 + ($lockKey == null ? 43 : $lockKey.hashCode());
            String $lockOwner = this.getLockOwner();
            result = result * 59 + ($lockOwner == null ? 43 : $lockOwner.hashCode());
            AtomicInteger $lockCount = this.getLockCount();
            result = result * 59 + ($lockCount == null ? 43 : $lockCount.hashCode());
            JdbcRegistryLockDTO $jdbcRegistryLock = this.getJdbcRegistryLock();
            result = result * 59 + ($jdbcRegistryLock == null ? 43 : ((Object)$jdbcRegistryLock).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "JdbcRegistryLockManager.LockEntry(lockKey=" + this.getLockKey() + ", lockOwner=" + this.getLockOwner() + ", lockCount=" + this.getLockCount() + ", jdbcRegistryLock=" + this.getJdbcRegistryLock() + ")";
        }

        @Generated
        public LockEntry() {
        }

        @Generated
        public LockEntry(String lockKey, String lockOwner, JdbcRegistryLockDTO jdbcRegistryLock) {
            this.lockKey = lockKey;
            this.lockOwner = lockOwner;
            this.jdbcRegistryLock = jdbcRegistryLock;
        }

        @Generated
        public static class LockEntryBuilder {
            @Generated
            private String lockKey;
            @Generated
            private String lockOwner;
            @Generated
            private JdbcRegistryLockDTO jdbcRegistryLock;

            @Generated
            LockEntryBuilder() {
            }

            @Generated
            public LockEntryBuilder lockKey(String lockKey) {
                this.lockKey = lockKey;
                return this;
            }

            @Generated
            public LockEntryBuilder lockOwner(String lockOwner) {
                this.lockOwner = lockOwner;
                return this;
            }

            @Generated
            public LockEntryBuilder jdbcRegistryLock(JdbcRegistryLockDTO jdbcRegistryLock) {
                this.jdbcRegistryLock = jdbcRegistryLock;
                return this;
            }

            @Generated
            public LockEntry build() {
                return new LockEntry(this.lockKey, this.lockOwner, this.jdbcRegistryLock);
            }

            @Generated
            public String toString() {
                return "JdbcRegistryLockManager.LockEntry.LockEntryBuilder(lockKey=" + this.lockKey + ", lockOwner=" + this.lockOwner + ", jdbcRegistryLock=" + this.jdbcRegistryLock + ")";
            }
        }
    }
}

