/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.openapi.models.V1ContainerState;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="ContainerStatus contains details for the current status of this container.")
public class V1ContainerStatus {
    public static final String SERIALIZED_NAME_CONTAINER_I_D = "containerID";
    @SerializedName(value="containerID")
    private String containerID;
    public static final String SERIALIZED_NAME_IMAGE = "image";
    @SerializedName(value="image")
    private String image;
    public static final String SERIALIZED_NAME_IMAGE_I_D = "imageID";
    @SerializedName(value="imageID")
    private String imageID;
    public static final String SERIALIZED_NAME_LAST_STATE = "lastState";
    @SerializedName(value="lastState")
    private V1ContainerState lastState;
    public static final String SERIALIZED_NAME_NAME = "name";
    @SerializedName(value="name")
    private String name;
    public static final String SERIALIZED_NAME_READY = "ready";
    @SerializedName(value="ready")
    private Boolean ready;
    public static final String SERIALIZED_NAME_RESTART_COUNT = "restartCount";
    @SerializedName(value="restartCount")
    private Integer restartCount;
    public static final String SERIALIZED_NAME_STARTED = "started";
    @SerializedName(value="started")
    private Boolean started;
    public static final String SERIALIZED_NAME_STATE = "state";
    @SerializedName(value="state")
    private V1ContainerState state;

    public V1ContainerStatus containerID(String containerID) {
        this.containerID = containerID;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Container's ID in the format 'docker://<container_id>'.")
    public String getContainerID() {
        return this.containerID;
    }

    public void setContainerID(String containerID) {
        this.containerID = containerID;
    }

    public V1ContainerStatus image(String image) {
        this.image = image;
        return this;
    }

    @ApiModelProperty(required=true, value="The image the container is running. More info: https://kubernetes.io/docs/concepts/containers/images")
    public String getImage() {
        return this.image;
    }

    public void setImage(String image) {
        this.image = image;
    }

    public V1ContainerStatus imageID(String imageID) {
        this.imageID = imageID;
        return this;
    }

    @ApiModelProperty(required=true, value="ImageID of the container's image.")
    public String getImageID() {
        return this.imageID;
    }

    public void setImageID(String imageID) {
        this.imageID = imageID;
    }

    public V1ContainerStatus lastState(V1ContainerState lastState) {
        this.lastState = lastState;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public V1ContainerState getLastState() {
        return this.lastState;
    }

    public void setLastState(V1ContainerState lastState) {
        this.lastState = lastState;
    }

    public V1ContainerStatus name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(required=true, value="This must be a DNS_LABEL. Each container in a pod must have a unique name. Cannot be updated.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public V1ContainerStatus ready(Boolean ready) {
        this.ready = ready;
        return this;
    }

    @ApiModelProperty(required=true, value="Specifies whether the container has passed its readiness probe.")
    public Boolean getReady() {
        return this.ready;
    }

    public void setReady(Boolean ready) {
        this.ready = ready;
    }

    public V1ContainerStatus restartCount(Integer restartCount) {
        this.restartCount = restartCount;
        return this;
    }

    @ApiModelProperty(required=true, value="The number of times the container has been restarted, currently based on the number of dead containers that have not yet been removed. Note that this is calculated from dead containers. But those containers are subject to garbage collection. This value will get capped at 5 by GC.")
    public Integer getRestartCount() {
        return this.restartCount;
    }

    public void setRestartCount(Integer restartCount) {
        this.restartCount = restartCount;
    }

    public V1ContainerStatus started(Boolean started) {
        this.started = started;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Specifies whether the container has passed its startup probe. Initialized as false, becomes true after startupProbe is considered successful. Resets to false when the container is restarted, or if kubelet loses state temporarily. Is always true when no startupProbe is defined.")
    public Boolean getStarted() {
        return this.started;
    }

    public void setStarted(Boolean started) {
        this.started = started;
    }

    public V1ContainerStatus state(V1ContainerState state) {
        this.state = state;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public V1ContainerState getState() {
        return this.state;
    }

    public void setState(V1ContainerState state) {
        this.state = state;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1ContainerStatus v1ContainerStatus = (V1ContainerStatus)o;
        return Objects.equals(this.containerID, v1ContainerStatus.containerID) && Objects.equals(this.image, v1ContainerStatus.image) && Objects.equals(this.imageID, v1ContainerStatus.imageID) && Objects.equals(this.lastState, v1ContainerStatus.lastState) && Objects.equals(this.name, v1ContainerStatus.name) && Objects.equals(this.ready, v1ContainerStatus.ready) && Objects.equals(this.restartCount, v1ContainerStatus.restartCount) && Objects.equals(this.started, v1ContainerStatus.started) && Objects.equals(this.state, v1ContainerStatus.state);
    }

    public int hashCode() {
        return Objects.hash(this.containerID, this.image, this.imageID, this.lastState, this.name, this.ready, this.restartCount, this.started, this.state);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1ContainerStatus {\n");
        sb.append("    containerID: ").append(this.toIndentedString(this.containerID)).append("\n");
        sb.append("    image: ").append(this.toIndentedString(this.image)).append("\n");
        sb.append("    imageID: ").append(this.toIndentedString(this.imageID)).append("\n");
        sb.append("    lastState: ").append(this.toIndentedString(this.lastState)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    ready: ").append(this.toIndentedString(this.ready)).append("\n");
        sb.append("    restartCount: ").append(this.toIndentedString(this.restartCount)).append("\n");
        sb.append("    started: ").append(this.toIndentedString(this.started)).append("\n");
        sb.append("    state: ").append(this.toIndentedString(this.state)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

