/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.oss.internal;

import com.aliyun.oss.ClientException;
import com.aliyun.oss.OSSEncryptionClient;
import com.aliyun.oss.OSSException;
import com.aliyun.oss.crypto.ContentCryptoMaterial;
import com.aliyun.oss.crypto.ContentCryptoMaterialRW;
import com.aliyun.oss.crypto.EncryptionMaterials;
import com.aliyun.oss.crypto.MultipartUploadCryptoContext;
import com.aliyun.oss.internal.OSSUploadOperation;
import com.aliyun.oss.model.CompleteMultipartUploadRequest;
import com.aliyun.oss.model.CompleteMultipartUploadResult;
import com.aliyun.oss.model.InitiateMultipartUploadRequest;
import com.aliyun.oss.model.InitiateMultipartUploadResult;
import com.aliyun.oss.model.UploadPartRequest;
import com.aliyun.oss.model.UploadPartResult;
import java.io.File;

public class OSSUploadOperationEncrypted
extends OSSUploadOperation {
    private OSSEncryptionClient ossEncryptionClient;
    private EncryptionMaterials encryptionMaterials;

    public OSSUploadOperationEncrypted(OSSEncryptionClient ossEncryptionClient, EncryptionMaterials encryptionMaterials) {
        super(ossEncryptionClient.getMultipartOperation());
        this.ossEncryptionClient = ossEncryptionClient;
        this.encryptionMaterials = encryptionMaterials;
    }

    @Override
    public OSSUploadOperation.UploadCheckPoint createUploadCheckPointWrap() {
        return new UploadCheckPointEncryption();
    }

    @Override
    public void loadUploadCheckPointWrap(OSSUploadOperation.UploadCheckPoint uploadCheckPoint, String checkpointFile) throws Throwable {
        OSSUploadOperationEncrypted.assertUploadCheckPointIsLegal(uploadCheckPoint);
        uploadCheckPoint.load(checkpointFile);
        ContentCryptoMaterial cryptoMaterial = ((UploadCheckPointEncryption)uploadCheckPoint).getContext().getContentCryptoMaterial();
        if (cryptoMaterial instanceof ContentCryptoMaterialRW) {
            this.encryptionMaterials.decryptCEK((ContentCryptoMaterialRW)cryptoMaterial);
        }
    }

    @Override
    public InitiateMultipartUploadResult initiateMultipartUploadWrap(OSSUploadOperation.UploadCheckPoint uploadCheckPoint, InitiateMultipartUploadRequest initiateMultipartUploadRequest) throws OSSException, ClientException {
        OSSUploadOperationEncrypted.assertUploadCheckPointIsLegal(uploadCheckPoint);
        MultipartUploadCryptoContext context = new MultipartUploadCryptoContext();
        context.setPartSize(uploadCheckPoint.originPartSize);
        File file = new File(uploadCheckPoint.uploadFile);
        context.setDataSize(file.length());
        InitiateMultipartUploadResult result = this.ossEncryptionClient.initiateMultipartUpload(initiateMultipartUploadRequest, context);
        ((UploadCheckPointEncryption)uploadCheckPoint).setContext(context);
        return result;
    }

    @Override
    public UploadPartResult uploadPartWrap(OSSUploadOperation.UploadCheckPoint uploadCheckPoint, UploadPartRequest uploadPartRequest) throws OSSException, ClientException {
        OSSUploadOperationEncrypted.assertUploadCheckPointIsLegal(uploadCheckPoint);
        return this.ossEncryptionClient.uploadPart(uploadPartRequest, ((UploadCheckPointEncryption)uploadCheckPoint).getContext());
    }

    @Override
    public CompleteMultipartUploadResult completeMultipartUploadWrap(OSSUploadOperation.UploadCheckPoint uploadCheckPoint, CompleteMultipartUploadRequest request) throws OSSException, ClientException {
        OSSUploadOperationEncrypted.assertUploadCheckPointIsLegal(uploadCheckPoint);
        return this.ossEncryptionClient.completeMultipartUpload(request, ((UploadCheckPointEncryption)uploadCheckPoint).getContext());
    }

    private static void assertUploadCheckPointIsLegal(OSSUploadOperation.UploadCheckPoint uploadCheckPoint) {
        if (!(uploadCheckPoint instanceof UploadCheckPointEncryption)) {
            throw new ClientException("the uploadCheckPoint of encryption client operation should instance of UploadCheckPointEncryption.");
        }
    }

    static class UploadCheckPointEncryption
    extends OSSUploadOperation.UploadCheckPoint {
        private MultipartUploadCryptoContext context;

        UploadCheckPointEncryption() {
        }

        public MultipartUploadCryptoContext getContext() {
            return this.context;
        }

        public void setContext(MultipartUploadCryptoContext context) {
            this.context = context;
        }

        @Override
        public int hashCode() {
            int result = super.hashCode();
            int prime = 31;
            result = 31 * result + (this.context == null ? 0 : this.context.hashCode());
            return result;
        }

        @Override
        public void assign(OSSUploadOperation.UploadCheckPoint ucp) {
            OSSUploadOperationEncrypted.assertUploadCheckPointIsLegal(ucp);
            super.assign(ucp);
            this.context = ((UploadCheckPointEncryption)ucp).context;
        }
    }
}

