/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.health;

import java.lang.reflect.Constructor;
import java.util.Map;
import org.springframework.beans.BeanUtils;
import org.springframework.core.ResolvableType;
import org.springframework.util.Assert;

public abstract class AbstractCompositeHealthContributorConfiguration<C, I extends C, B> {
    private final Class<?> indicatorType;
    private final Class<?> beanType;

    AbstractCompositeHealthContributorConfiguration() {
        ResolvableType type = ResolvableType.forClass(AbstractCompositeHealthContributorConfiguration.class, this.getClass());
        this.indicatorType = type.resolveGeneric(new int[]{1});
        this.beanType = type.resolveGeneric(new int[]{2});
    }

    protected final C createContributor(Map<String, B> beans) {
        Assert.notEmpty(beans, (String)"Beans must not be empty");
        if (beans.size() == 1) {
            return (C)this.createIndicator(beans.values().iterator().next());
        }
        return this.createComposite(beans);
    }

    protected abstract C createComposite(Map<String, B> var1);

    protected I createIndicator(B bean) {
        try {
            Constructor<?> constructor = this.indicatorType.getDeclaredConstructor(this.beanType);
            return (I)BeanUtils.instantiateClass(constructor, (Object[])new Object[]{bean});
        }
        catch (Exception ex) {
            throw new IllegalStateException("Unable to create health indicator " + this.indicatorType + " for bean type " + this.beanType, ex);
        }
    }
}

