/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sagemaker.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.sagemaker.model.TransformOutput;

@SdkInternalApi
public class TransformOutputMarshaller {
    private static final MarshallingInfo<String> S3OUTPUTPATH_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("S3OutputPath").build();
    private static final MarshallingInfo<String> ACCEPT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Accept").build();
    private static final MarshallingInfo<String> ASSEMBLEWITH_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AssembleWith").build();
    private static final MarshallingInfo<String> KMSKEYID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("KmsKeyId").build();
    private static final TransformOutputMarshaller instance = new TransformOutputMarshaller();

    public static TransformOutputMarshaller getInstance() {
        return instance;
    }

    public void marshall(TransformOutput transformOutput, ProtocolMarshaller protocolMarshaller) {
        if (transformOutput == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)transformOutput.getS3OutputPath(), S3OUTPUTPATH_BINDING);
            protocolMarshaller.marshall((Object)transformOutput.getAccept(), ACCEPT_BINDING);
            protocolMarshaller.marshall((Object)transformOutput.getAssembleWith(), ASSEMBLEWITH_BINDING);
            protocolMarshaller.marshall((Object)transformOutput.getKmsKeyId(), KMSKEYID_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

