/*
 * Decompiled with CFR 0.152.
 */
package com.qcloud.cos.internal.crypto;

import com.qcloud.cos.auth.COSCredentials;
import com.qcloud.cos.auth.COSCredentialsProvider;
import com.qcloud.cos.exception.CosClientException;
import com.qcloud.cos.internal.crypto.QCLOUDKMS;
import com.tencentcloudapi.common.Credential;
import com.tencentcloudapi.common.exception.TencentCloudSDKException;
import com.tencentcloudapi.kms.v20190118.KmsClient;
import com.tencentcloudapi.kms.v20190118.models.DecryptRequest;
import com.tencentcloudapi.kms.v20190118.models.DecryptResponse;
import com.tencentcloudapi.kms.v20190118.models.EncryptRequest;
import com.tencentcloudapi.kms.v20190118.models.EncryptResponse;
import com.tencentcloudapi.kms.v20190118.models.GenerateDataKeyRequest;
import com.tencentcloudapi.kms.v20190118.models.GenerateDataKeyResponse;

public class TencentCloudKMSClient
implements QCLOUDKMS {
    private final KmsClient kmsClient;

    public TencentCloudKMSClient(COSCredentialsProvider cosCredentialsProvider, String region) {
        COSCredentials cosCredentials = cosCredentialsProvider.getCredentials();
        String secretId = cosCredentials.getCOSAccessKeyId();
        String secretKey = cosCredentials.getCOSSecretKey();
        Credential credential = new Credential(secretId, secretKey);
        this.kmsClient = new KmsClient(credential, region);
    }

    @Override
    public GenerateDataKeyResponse generateDataKey(GenerateDataKeyRequest generateDataKeyRequest) {
        try {
            GenerateDataKeyResponse generateDataKeyRes = this.kmsClient.GenerateDataKey(generateDataKeyRequest);
            return generateDataKeyRes;
        }
        catch (TencentCloudSDKException e) {
            throw new CosClientException("TencentCloudKMS Service got exception while GenerateDataKey", e);
        }
    }

    @Override
    public EncryptResponse encrypt(EncryptRequest encryptRequest) {
        try {
            EncryptResponse encryptResponse = this.kmsClient.Encrypt(encryptRequest);
            return encryptResponse;
        }
        catch (TencentCloudSDKException e) {
            throw new CosClientException("TencentCloudKMS Service got exception while Encrypt", e);
        }
    }

    @Override
    public DecryptResponse decrypt(DecryptRequest decryptRequest) {
        try {
            DecryptResponse decryptResponse = this.kmsClient.Decrypt(decryptRequest);
            return decryptResponse;
        }
        catch (TencentCloudSDKException e) {
            throw new CosClientException("TencentCloudKMS Service got exception while Decrypt", e);
        }
    }

    @Override
    public void shutdown() {
    }
}

