/*
 * Decompiled with CFR 0.152.
 */
package org.springdoc.core.providers;

import java.lang.reflect.Field;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.core.convert.converter.GenericConverter;
import org.springframework.core.convert.support.GenericConversionService;
import org.springframework.format.support.DefaultFormattingConversionService;
import org.springframework.format.support.FormattingConversionService;
import org.springframework.lang.Nullable;

public class WebConversionServiceProvider {
    private static final String CONVERTERS = "converters";
    private static final Logger LOGGER = LoggerFactory.getLogger(WebConversionServiceProvider.class);
    private GenericConversionService formattingConversionService;

    public WebConversionServiceProvider(Optional<List<GenericConversionService>> webConversionServiceOptional) {
        if (webConversionServiceOptional.isPresent()) {
            List<GenericConversionService> conversionServiceList = webConversionServiceOptional.get();
            for (GenericConversionService genericConversionService : conversionServiceList) {
                if (!(genericConversionService instanceof FormattingConversionService)) continue;
                this.formattingConversionService = genericConversionService;
                break;
            }
        }
        if (this.formattingConversionService == null) {
            this.formattingConversionService = new DefaultFormattingConversionService();
        }
    }

    @Nullable
    public Object convert(@Nullable Object source, TypeDescriptor targetTypeDescriptor) {
        return this.formattingConversionService.convert(source, targetTypeDescriptor);
    }

    public Class<?> getSpringConvertedType(Class<?> clazz) {
        Class result = clazz;
        Field convertersField = FieldUtils.getDeclaredField(GenericConversionService.class, (String)CONVERTERS, (boolean)true);
        if (convertersField != null) {
            try {
                Object converters = convertersField.get(this.formattingConversionService);
                convertersField = FieldUtils.getDeclaredField(converters.getClass(), (String)CONVERTERS, (boolean)true);
                Map springConverters = (Map)convertersField.get(converters);
                Optional<GenericConverter.ConvertiblePair> convertiblePairOptional = springConverters.keySet().stream().filter(convertiblePair -> convertiblePair.getTargetType().equals(clazz)).findAny();
                if (convertiblePairOptional.isPresent()) {
                    GenericConverter.ConvertiblePair convertiblePair2 = convertiblePairOptional.get();
                    result = convertiblePair2.getSourceType();
                }
            }
            catch (IllegalAccessException e) {
                LOGGER.warn(e.getMessage());
            }
        }
        return result;
    }
}

